<?php
namespace Plugins\Yooz_Manager;
use Core\ErrorsTrait;
use Core\File_Uploader;
use Core\Utils;
use Plugins\Yooz_Manager\Yooz_Manager_Utils;

class Yooz_Manager_Ajax{
    use ErrorsTrait;
    public function ajax_response(string $action){
        $response = [];
        $method_name = $action."_ajax";
        if(method_exists(self::class , $method_name)){
            $response = $this->$method_name();
        }
        if($this->has_error()){
            $response = ['responseType'=>'error' , 'responseText'=>$this->get_errors_text()];
        }
        return $response;
    }

    private function pagination_ajax(){
        $response = [];
        if(!empty($_POST['request_page']) && is_numeric($_POST['request_page'])){
            $page = intval($_POST['request_page']);
            $search_term = !empty($_POST['search_term']) ? Utils::test_input($_POST['search_term']) : "";
            $yooz = new YOOZ_Manager($page , false , $search_term);
            $responseText = $yooz->get_yooz_template("environment");
            $response = ['responseType'=>'success' , 'responseText'=>$responseText];
            $yooz->close();
        }
        return $response;
    }

    private function search_ajax(){
        $response = [];
        if(isset($_POST['search_term'])){
            $search_term = Utils::test_input($_POST['search_term']);
            $yooz = new YOOZ_Manager(1 , false , $search_term);
            $responseText = $yooz->get_yooz_template("environment");
            $response = ['responseType'=>'success' , 'responseText'=>$responseText];
            $yooz->close();
        }
        return $response;
    }

    private function upload_file_ajax(){
        $response = [];
        if(!empty($_POST['server_name'])){
            if(!empty($_FILES['file'])){
                $serverName = Utils::test_input($_POST['server_name']);
                $uploader = new File_Uploader($_FILES['file'] , $serverName);
                if($uploader->uplaod_file()){
                    $page = (!empty($_POST['request_page']) && is_numeric($_POST['request_page'])) ? intval($_POST['request_page']) : 1;
                    $search_term = !empty($_POST['search_term']) ? Utils::test_input($_POST['search_term']) : "";
                    $manager = new YOOZ_Manager($page , false, $search_term);
                    $responseText = $manager->get_yooz_template("library");
                    $response = ['responseType'=>'success' , 'responseText'=>$responseText];
                    $manager->close();
                }else{
                    $this->set_error($uploader->get_errors_text());
                }
            }else{
                $this->set_error("هیچ فایلی ارسال نشده است.");
            }
        }else{
            $this->set_error("نام سرور برای ذخیره فایل وارد نشده است.");
        }
        return $response;
    }

    private function get_template_ajax(){
        $template = !empty($_POST['template']) ? Utils::test_input($_POST['template']) : "window";
        $manager = new YOOZ_Manager();
        $responseText = $manager->get_yooz_template($template);
        if($manager->has_error()){
            $responseType = "error";
            $responseText = $manager->get_errors_text();
        }else{
            $responseType = 'success';
        }
        return ['responseType'=>$responseType , 'responseText'=>$responseText];
    }
    
    public function delete_file_ajax(){
        $response = [];
        
        if(!empty($_POST['file_id']) && is_numeric($_POST['file_id'])){
            $id = intval($_POST['file_id']);
            if($id > 0){
                $file = Yooz_Manager_Utils::get_file_by_id($id);
                if(!empty($file) && is_array($file) && !empty($file['file_url'])){
                    $result = Yooz_Manager_Utils::delete_file($file);
                    if($result){
                        $response = ['responseType'=>"success" , 'responseText'=>"فایل با موفقیت حذف شد."];
                    }else{
                        $this->set_error("خطا در انجام عملیات");
                    }
                }else{
                    $this->set_error("فایل مورد نظر یافت نشد!");
                }
            }else{
                $this->set_error("شناسه فایل اشتباه است.");
            }
        }else{
            $this->set_error("شناسه فایل وارد نشده است.");
        }
        
        return $response;
    }
}