<?php
namespace Plugins\Yooz_Manager;
use Core\ErrorsTrait;
use Core\YoozDB;
use Plugins\Yooz_Manager\Core\Template_Renderer;
use Plugins\Yooz_Manager\Core\Yooz_Pagination;
class YOOZ_Manager{
    use ErrorsTrait;
    private $table_name = "yooz_file_manager";
    protected $db = null;
    private $allFilesCount = 0;
    private $recordsCount = 0;
    private $fielsRecords = null;
    private $filePerPage = 30;
    private $requestPage = 1;
    public $js_script_file = "";
    private $ftp_configs;
    private $search_term = "";

    public function __construct($page = 1 , $add_js_script_file = true , $search_term = "")
    {
        if(is_int($page)){
            $db = new YoozDB();
            if($db->check_connection()){
                $this->db = $db;
                $this->ftp_configs = $this->db->get_ftp_configs();
                $this->requestPage = $page;
                $this->js_script_file = ($add_js_script_file) ? $this->get_yooz_script() : "";
                $this->search_term = is_string($search_term) ? $search_term : "";
                $search_query = $this->get_search_query();
                if($this->db->table_exists($this->table_name)){
                    $filesCountResult = $this->db->select($this->table_name , "count(*)", $search_query);
                    $this->allFilesCount = $filesCountResult->fetch()['count(*)'];
                    $startRecord = ($this->requestPage - 1) * $this->filePerPage;
                    $this->clear_connection($filesCountResult);
                    $filesResult = $this->db->select($this->table_name , "*" , $search_query." ORDER BY file_ID DESC" , $startRecord." , ".$this->filePerPage);
                    if($filesResult->rowCount() > 0){
                        $this->store_files_result($filesResult);
                    }
                    $this->clear_connection($filesResult);
                }else{
                    $this->db->create_table($this->table_name , array(
                        "file_ID INT(11) UNSIGNED AUTO_INCREMENT PRIMARY KEY",
                        "file_type TEXT NOT NULL",
                        "file_name TEXT NOT NULL",
                        "file_title TEXT NOT NULL",
                        "file_url TEXT NOT NULL",
                        "file_path TEXT NOT NULL",
                        "server_url TEXT NOT NULL",
                        "file_data LONGTEXT NOT NULL",
                    ));
                    header("Refresh:0");
                }
            }else{
                $this->set_error("ارتباط با دیتابیس برقرار نشد. لطفا صحت اطلاعات ارتباط با دیتابیس را بررسی کنید.");
            }
        }
    }
    public function get_yooz_template($template_name = "environment"){
        if(!$this->has_error()){
            if($template_name == "environment"){
                return $this->get_manager_environment();
            }elseif($template_name == "window"){
                return $this->get_window_template();
            }elseif($template_name == "library"){
                return $this->get_manager_library();
            }elseif($template_name == "files"){
                return $this->get_files_template();
            }else{
                return '<div class="yooz_fm_template_error_message">قالب خواسته شده تعریف نشده است.</div>';
            }
        }else{
            return $this->get_errors_text();
        }
    }
    private function get_window_template(){
        $data = array('environment'  => $this->get_manager_environment());
        $renderer = new Template_Renderer();
        return $renderer->render_template(dirname(__FILE__)."/views/yooz_window_view.php" , $data);
    }
    private function get_manager_environment(){
        $data['yooz_manager_script_file'] = $this->js_script_file;
        $data['server_names_as_select_options'] = $this->get_server_names_as_option();
        $data['manager_library'] = $this->get_manager_library();
        $data['request_page'] = $this->requestPage;
        $renderer = new Template_Renderer();
        return $renderer->render_template(dirname(__FILE__)."/views/yooz_manager_view.php" , $data);
    }
    private function get_manager_library(){
        $data = array('files_template'  => $this->get_files_template());
        $pagination = new Yooz_Pagination();
        $data['file_pagination'] =$pagination->get_pagination($this->requestPage , $this->allFilesCount, $this->filePerPage);
        $data['search_value'] = $this->search_term;
        $renderer = new Template_Renderer();
        return $renderer->render_template(dirname(__FILE__)."/views/yooz_library_view.php" , $data);
    }
    private function get_files_template(){
        $template = "";
        $file_item_template = file_get_contents(dirname(__FILE__) . "/views/yooz_file_item_view.php");
        $renderer = new Template_Renderer();
        if(is_array($this->fielsRecords) && count($this->fielsRecords) > 0){
            foreach ($this->fielsRecords as $file){
                $data = $file;
                if($file['file_type'] == "image"){
                    $data['file_thumbnail'] = !empty(unserialize($file['file_data'])['small_thumbnail']) ? unserialize($file['file_data'])['small_thumbnail'] : "/includes/emptyImage.jpg";
                }else{
                    $data['file_thumbnail'] = "/includes/".$file['file_type']."_file_icon.svg";
                }
                $template .= $renderer->render_template($file_item_template , $data , true);
            }
        }
        if(empty($template)){
            $template = '<div class="yooz_fm_environment_message"><p class="alert">هیچ فایلی یافت نشد.</p></div>';
        }
        return $template;
    }
    private function get_search_query(){
        $search_term = $this->search_term;
        if(!empty($search_term)){
            $search_query = "file_name LIKE '%".$search_term."%'";
        }
        return !empty($search_query) ? $search_query : "file_name IS NOT NULL";
    }
    private function store_files_result($filesResult){
        $sorted_files = [];
        $this->recordsCount = $filesResult->rowCount();
        $sort_Records = false;
        if(!empty($this->search_term)){
            $explodedTerm = explode(" " , $this->search_term);
            $searchWordsCount = (is_array($explodedTerm) && count($explodedTerm)) ? count($explodedTerm) : 0;
            $sort_Records = true;
        }

        if($filesResult && $filesResult->rowCount() > 0){
            while($fileRow = $filesResult->fetch()){
                if($sort_Records && $searchWordsCount > 0){
                    /* get similarity value in percent */
                    $percentage = 0;
                    foreach ($explodedTerm as $word) {
                        if(!empty($word)) {
                            if(strpos($fileRow['file_name'], $word) !== false){
                                $percentage = $percentage + (100 / ($searchWordsCount * 2));
                            }
                        }
                    }
                    $fileRow['searchValue'] = $percentage;
                }
                $sorted_files[] = $fileRow;
            }
            /* sort results by its search value percentage if search_term is not empty */
            if($sort_Records && $searchWordsCount > 0){
                usort($sorted_files, function ($a, $b) {
                    if(isset($b['searchValue']) && isset($a['searchValue'])){
                        return $b['searchValue'] - $a['searchValue'];
                    }else{
                        return 0;
                    }
                });
            }
        }

        $this->fielsRecords = $sorted_files;
        return $sorted_files;
    }
    protected function get_server_names_as_option(){
        $options = '';
        $configs = $this->ftp_configs;
        if($configs && is_array($configs) && count($configs) > 0){
            $options .= '<option value="0">انتخاب کنید...</option>';
            foreach($configs as $confName => $conf){
                $options .= '<option value="'.$confName.'">'.$confName.'</option>';
            }
        }
        $options .= '<option value="local">هاست محلی</option>';
        return $options;
    }
    protected function get_yooz_script(){
        return '<script type="text/javascript" src="/js/admin_yooz_manager.js" id="yooz_manager_script_file"></script>';
    }
    protected function get_yooz_dir(){
        $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
        return $protocol.$_SERVER['HTTP_HOST'].str_replace($_SERVER['DOCUMENT_ROOT'] , '' , str_replace("\\", "/" ,dirname(__FILE__)));
    }
    public function close(){
        $this->db = null;
    }
    public function clear_connection($connection){
        $connection = null;
    }
}
?>