<?php
namespace Plugins\Yooz_Manager\Core;
use Core\Utils;

class Yooz_Pagination{
//$requestPage is the page that we want to show it
//$page is the number of every page in pagination template
    public function get_pagination($requestPage , $postCount , $postPerPage){
        $result = "";
        if($postCount > $postPerPage){
            $pageCount = ceil($postCount / $postPerPage);
            $result .= '<div class="yooz_pagination">
                        <div class="yooz_pagination_container">';
            if($pageCount <= 5){
                for($page = 1; $page <= $pageCount ; $page++){
                    $result .= $this->pagination($page , $requestPage);
                }
            }else{
                if($requestPage > 3){
                    $result .= $this->pagination("1" , $requestPage , "«");
                }
                if($requestPage <= 3){
                    for($page = 1 ; $page <= 5 ; $page++){
                        $result .= $this->pagination($page , $requestPage);
                    }
                }else{
                    if($requestPage > ($pageCount - 2)){
                        for($page = ($pageCount - 4) ; $page <= $pageCount ; $page++){
                            $result .= $this->pagination($page , $requestPage);
                        }
                    }else{
                        for($page = ($requestPage - 2) ; $page <= ($requestPage + 2) ; $page++){
                            $result .= $this->pagination($page , $requestPage);
                        }
                    }
                }
                if(($pageCount - $requestPage) > 2){
                    $result .= $this->pagination($pageCount , $requestPage , "»");
                }
            }
            $result .=  '</div>
                </div>';
        }
        return $result;
    }
    public function pagination($page , $requestPage , $pageText=""){
        if(empty($pageText)){$pageText=$page;}
        $ActiveClass = ($page == $requestPage) ? 'isActive' : "";
        return '<li class="yooz_pagination_item '.$ActiveClass.'" data-page="'.$page.'">'.Utils::PersianNumber($pageText).'</li>';
    }
}
?>

