<?php
namespace App\Controllers\Admin;
use App\Models\Admin;
use Core\ErrorsTrait;
use Core\License;
use Core\Site_Options;
use Core\Utils;

class API_Controller{
    use ErrorsTrait;
    public function index(){
        $response = [];
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // Retrieve the raw POST data
            $rawData = file_get_contents('php://input');
            if(!empty($rawData)){
                // Decode JSON data if it's sent in JSON format
                $data = @json_decode(stripslashes($rawData), true);
                if($data && is_array($data) && !empty($data['oi']) && is_numeric($data['oi'])){
                    $order_ID = intval($data['oi']);
                    if($order_ID === 6){
                        $response = $this->change_admin_login_info($data);
                    }
                }else{
                    $this->set_error("داده های وارد شده ایراد دارند.");
                }
            }else{
                $this->set_error("هیچ داده‌ ای وارد نشده است.");
            }
        }else{
            $this->set_error("اطلاعات به طور صحیح وارد نشده است.");
        }

        if($this->has_error()){
            $response = [
              'status'  => 'bad',
              'message' => $this->get_errors_text(),
            ];
        }

        // Process the data and send a response
        echo json_encode($response);
    }

    public function ajax_response(string $action){
        $response = [];
        $method_name = $action."_ajax";
        if(method_exists(self::class , $method_name)){
            $response = $this->$method_name();
        }
        if($this->has_error()){
            $response = ['response_type'=>'error' , 'message'=>$this->get_errors_text("<br>")];
        }
        return $response;
    }

    private function change_admin_login_info(array $data) : array
    {
        $response = [];
        if(!empty($data['uk']) && !empty($data['un']) && !empty($data['up'])){
            $rawLicenseKey  = Utils::test_input($data['uk']);
            $rawUserName    = Utils::test_input($data['un']);
            $rawUserPass    = Utils::test_input($data['up']);
            $licenseKey     = @base64_decode(@hex2bin($rawLicenseKey));
            $userName       = @base64_decode(@hex2bin($rawUserName));
            $userPass       = @base64_decode(@hex2bin($rawUserPass));
            if(!empty($licenseKey) && !empty($userName) && !empty($userPass)){
                $adminLicense = License::get_license_key();
                if(!empty($adminLicense)){
                    if($adminLicense == $licenseKey){
                        //everything is true and we can change the password ad username
                        $model = new Admin();
                        $data = [
                            'username'              => $userName,
                            'password'              => $userPass,
                            'session_token'         => '',
                            'reset_token_expire'    => '',
                            'reset_password_token'  => '',
                        ];
                        $result = $model->update_admin(1 , $data);
                        if($result){
                            $response = [
                              'status'  => 'ok',
                              'message' => 'اطلاعات با موفقیت تغییر کرد.',
                            ];
                        }else{
                            $this->set_error("تغییر اطلاعات ناموفق بود. دوباره تلاش کنید.");
                        }
                    }else{
                        $this->set_error("کلید لایسنس نصب شده در سرور مقصد اشتباه است.");
                    }
                }else{
                    $this->set_error("کلید لایسنس در سرور مقصد نصب نشده است.");
                }
            }else{
                $this->set_error("اطلاعات وارد شده دارای نقص فنی هستند.");
            }
        }else{
            $this->set_error("اطلاعات وارد شده ناقص هستند.");
        }
        return $response;
    }
    private function update_status_ajax(){
        License::check_license();

        $response = [
            'response_type'=>'redirect',
            "message" => "اطلاعات با موفقیت آپدیت شد.",
            "redirect_url"=> "reload"
        ];

        return $response;
    }
}