<?php
namespace App\Controllers\Admin;
use App\Models\Game_Model;
use App\Models\UserModel;
use Core\Controller;
use Core\ErrorsTrait;
use Core\Excel;
use Core\Utils;
use Core\JDate;
use Core\Validators\Phone_Validator;

class Customers_Controller extends Controller{
    use ErrorsTrait;
    public function index(){
        $usersModel = new UserModel();
        $lastRegisteredUsers = $usersModel->get_players("user_ID IS NOT NULL ORDER BY user_ID DESC" , "5");
        /* get top 5 users */
        $top5Users = $usersModel->get_players("user_ID IS NOT NULL ORDER BY total_score DESC , user_ID ASC" , "5");

        $data = [
            'page_title'            => 'مدیریت مشتریان',
            'lastRegisteredUsers'   => $lastRegisteredUsers,
            'top5Users'             => $top5Users,
        ];

        $this->view->render("customers" , $data);
    }

    public function customer_details(){
        if(!empty($_GET['id']) && is_numeric($_GET['id'])){
            $user_ID = intval($_GET['id']);
            $userModel = new UserModel();
            $user = $userModel->get_player("user_ID='$user_ID'");
            if($user && is_array($user)){
                $data = [
                    'page_title'            => 'جزئیات اطلاعات کاربر',
                    'user'                  => $user,
                ];
                $this->view->render("user_details" , $data);
            }else{
                $this->set_error("شناسه کاربر اشتباه است.");
            }
        }else{
            $this->set_error("شناسه کاربری وارد نشده است.");
        }

        if($this->has_error()){
            $message = $this->get_errors_text();
            echo '<script>alert("'.$message.'");history.go(-1);</script>';
        }
    }

    public function customer_list(){
        $userModel = new UserModel();
        if(!empty($_GET['order']) && $_GET['order'] == "top_users"){
            $users = $userModel->get_players("user_ID IS NOT NULL ORDER BY total_score DESC , user_ID ASC");
            $title = "لیست برترین کاربران";
        }else{
            $users = $userModel->get_players("user_ID IS NOT NULL ORDER BY user_ID DESC");
            $title = "لیست کاربران به ترتیب تاریخ ثبت نام";
        }

        $data = [
            'page_title'    => 'جزئیات اطلاعات کاربر',
            'users'         => $users,
            'title'         => $title,
        ];
        $this->view->render("customer_list" , $data);
    }

    public function ajax_response(string $action){
        $response = [];
        $method_name = $action."_ajax";
        if(method_exists(self::class , $method_name)){
            $response = $this->$method_name();
        }

        if($this->has_error()){
            $response = ['response_type'=>'error' , 'message'=>$this->get_errors_text()];
        }

        return $response;
    }

    private function export_users_data_ajax(){
        $jDate = new JDate();
        $response = [];
        $excel = new Excel();
        $userModel = new UserModel();
        $users = $userModel->get_players();
        if($users && is_array($users)){
            $data = [
                ['نام' , 'نام خانوادگی' , 'لقب' , 'جنسیت' , 'تلفن همراه' , 'استان', 'شهر' , 'تعداد کل مدال ها' , 'تاریخ تولد' , 'تاریخ ثبت نام'],
            ];
            foreach ($users as $user){
                $first_name = !empty($user['name']) ? $user['name'] : 'نامشخص';
                $last_name = !empty($user['family']) ? $user['family'] : 'نامشخص';
                $display_name = $user['display_name'];
                $gender = !empty($user['gender']) ? ($user['gender'] == "male" ? "آقا" : "خانم") : "نامشخص";
                $phone = $user['phone'];
                $medals_number = !empty($user['medals_number']) && is_numeric($user['medals_number']) ? intval($user['medals_number']) : 0;
                $province = !empty($user['province']) ? $user['province'] : "نامشخص";
                $city = !empty($user['city']) ? $user['city'] : "نامشخص";
                $birthdate = !empty($user['birthdate']) ? Utils::PersianNumber(\Core\JDate::date("Y/m/d" ,strtotime($user['birthdate']))) : "نامشخص";
                $regDate = !empty($user['user_register_date']) ? Utils::PersianNumber(\Core\JDate::date("Y/m/d" ,strtotime($user['user_register_date']))) : "نامشخص";
                $data[] = [$first_name , $last_name , $display_name , $gender , $phone , $province ,$city , $medals_number , $birthdate , $regDate];

                $file_path = $excel->export($data);
                if($file_path){
                    $response = [
                        'response_type' => 'redirect',
                        'redirect_url'  => SITE_URL.$file_path,
                    ];
                }else{
                    $this->set_error($excel->get_errors_text("<br>"));
                }

            }
        }else{
            $this->set_error("هیچ کاربری یافت نشد.");
        }
        return $response;
    }

    private function search_user_ajax(){
        $response = [];
        if(!empty($_POST['customer_phone'])){
            $userModel = new UserModel();
            $phone = Utils::test_input($_POST['customer_phone']);
            $phoneValidator = new Phone_Validator();
            if($phoneValidator->validate($phone)){
                $user = $userModel->get_player("phone='$phone'");
                if(!empty($user) && is_array($user)){

                    require_once __DIR__."/../../Views/Admin/template-parts/customers/customers_search_info.php";
                    $structure = get_searched_user_structure($user);

                    $response = [
                        'response_type' => 'success',
                        'structure'     => $structure,
                    ];
                }else{
                    $this->set_error("کاربری با این شماره همراه یافت نشد!");
                }
            }else{
                $this->set_error("فرمت شماره همراه وارد شده صحیح نیست. شماره موبایل باید با 09 آغاز شده و 11 رقمی باشد.");
            }
        }else{
            $this->set_error("شماره همراه کاربر را وارد کنید.");
        }

        return $response;
    }

    private function change_user_gift_status_ajax(): array
    {
        $response = [];
        if(!empty($_POST['user_ID']) && is_numeric($_POST['user_ID']) && !empty($_POST['gift_ID']) && is_numeric($_POST['gift_ID'])){
            $user_ID = intval($_POST['user_ID']);
            $gift_ID = intval($_POST['gift_ID']);
            $model = new Game_Model();
            $result = $model->set_user_gift_status("user_ID='$user_ID' AND gift_ID='$gift_ID'" , "used");
            if($result){
                $response = [
                    'response_type' => 'success',
                ];
            }else{
                $this->set_error("عملیات ناموفق! دوباره تلاش کنید.");
            }
        }else{
            $this->set_error("شناسه وارد نشده است.");
        }
        return $response;
    }

    private function change_user_event_status_ajax(): array
    {
        $response = [];
        if(!empty($_POST['user_ID']) && is_numeric($_POST['user_ID']) && !empty($_POST['event_ID']) && is_numeric($_POST['event_ID'])){
            $user_ID = intval($_POST['user_ID']);
            $event_ID = intval($_POST['event_ID']);
            $model = new Game_Model();
            $result = $model->set_user_event_status("user_ID='$user_ID' AND event_ID='$event_ID'" , "used");
            if($result){
                $response = [
                    'response_type' => 'success',
                ];
            }else{
                $this->set_error("عملیات ناموفق! دوباره تلاش کنید.");
            }
        }else{
            $this->set_error("شناسه وارد نشده است.");
        }
        return $response;
    }

    private function add_coins_to_user_ajax(){
        $response = [];
        if(!empty($_POST['user_ID'])  && is_numeric($_POST['user_ID']) && !empty($_POST['coins_number']) && is_numeric($_POST['coins_number'])){
            $user_ID = intval($_POST['user_ID']);
            $coins_number = intval($_POST['coins_number']);
            $model = new Game_Model();
            $data = [
                'user_ID'           => $user_ID,
                'message_title'     => "هدیه مدیریت",
                'message_text'      => "کاربر عزیز، تعدادی سکه هدیه از طرف مدیریت برای شما واریز شد. برای بدست آوردن آن روی دکمه زیر بزنید.",
                'gift_coins'        => $coins_number,
            ];

            $result = $model->set_notification($data);
            if($result){
                $response = [
                    'response_type' => 'message',
                    'message'       => 'سکه ها با موفقیت به حساب کاربر واریز شد.',
                ];
            }else{
                $this->set_error("عملیات ناموفق! دوباره تلاش کنید.");
            }
        }else{
            $this->set_error("اطلاعات خواسته شده را وارد کنید.");
        }
        return $response;
    }
}