<?php
namespace App\Controllers\Admin;
use App\Models\Events_Model;
use App\Models\Game_Model;
use App\Models\Gifts_Model;
use App\Models\Lottery_Model;
use App\Models\Missions_Model;
use App\Models\UserModel;
use Core\Controller;
use Core\ErrorsTrait;
use Core\JDate;
use Core\Utils;
use Plugins\Yooz_Manager\Yooz_Manager_Utils;

class Game_Gifts_Controller extends Controller{
    use ErrorsTrait;
    public function index(){
        $giftsModel = new Gifts_Model();
        $git_items = $giftsModel->get_gifts();
        $gifts = $giftsModel->get_gifts();
        $allGifts = array(0 => 'هیچ');
        if($gifts && is_array($gifts)){
            foreach ($gifts as $gift){
                $allGifts[$gift['gift_ID']] = $gift['gift_name'];
            }
        }

        $eventsModel = new Events_Model();
        $event_items = $eventsModel->get_events();

        $missionModel = new Missions_Model();
        $missions = $missionModel->get_missions();
        $allMissions = array(0 => 'هیچ');
        if($missions && is_array($missions)){
            foreach ($missions as $mission){
                $allMissions[$mission['mission_ID']] = $mission['mission_title'];
            }
        }

        $data = [
            'page_title'    => "تعریف جایزه‌ها",
            'gift_items'    => $git_items && is_array($git_items) ? $git_items : [],
            'event_items'    => $event_items && is_array($event_items) ? $event_items : [],
            'all_missions'      => $allMissions,
            'all_gifts'      => $allGifts,
        ];
        $this->view->render("game_gifts" , $data);
    }

    public function ajax_response(string $action){
        $response = [];
        $method_name = $action."_ajax";
        if(method_exists(self::class , $method_name)){
            $response = $this->$method_name();
        }

        if($this->has_error()){
            $response = ['response_type'=>'error' , 'message'=>$this->get_errors_text()];
        }

        return $response;
    }

    private function get_gift_info_ajax(){
        $response = [];
        if(isset($_POST['gift_ID'])){
            $giftID = intval($_POST['gift_ID']);
            $model = new Gifts_Model();
            $result = $model->get_gift_by_id($giftID);
            if($giftID == 0){
                $result = [
                    'gift_ID'               => $giftID,
                    "image_url"             => "/public/uploads/emptyImage.jpg",
                    'gift_recharge_timing'  => "day",
                    'gift_expire_timing'    => "day",
                    'gift_status'           => "yes",
                ];
            }
            if($result){
                $response = ["response_type"=>"success" , "message" => $result];
            }else{
                $this->set_error("شناسه کارت وارد نشده است.");
            }
        }else{
            $this->set_error("شناسه جایزه وارد نشده است.");
        }
        return $response;
    }

    private function save_gift_ajax(){
        $response = [];
        $model = new Gifts_Model();
        $gift_ID                = isset($_POST['gift_ID']) ? Utils::test_input($_POST['gift_ID']) : false;
        $gift_name              = !empty($_POST['gift_name']) ? Utils::test_input($_POST['gift_name']) : "";
        $gift_description       = !empty($_POST['gift_description']) ? Utils::test_input($_POST['gift_description']) : "";
        $gift_claim_description = !empty($_POST['gift_claim_description']) ? Utils::test_input($_POST['gift_claim_description']) : "";
        $required_coins         = !empty($_POST['required_coins']) ? intval(Utils::EnglishNumber($_POST['required_coins'])) : 0;
        $gift_expire_time       = !empty($_POST['gift_expire_time']) ? intval(Utils::EnglishNumber($_POST['gift_expire_time'])) : false;
        $gift_expire_timing     = !empty($_POST['gift_expire_timing']) ? Utils::test_input($_POST['gift_expire_timing']) : "day";
        $gift_image_id          = !empty($_POST['gift_image_id']) ? intval($_POST['gift_image_id']) : 0;
        $gift_status            = !empty($_POST['gift_status']) ? Utils::test_input($_POST['gift_status']) : "yes";

        /* validate data */
        if(empty($gift_name) || empty($gift_description) || empty($gift_claim_description) || empty($required_coins)){
            $this->set_error("تمامی اطلاعات خواسته شده را تکمیل نمایید.");
        }
        if($gift_status !== "yes" && $gift_status !== "no"){
            $this->set_error("مقدار انتخاب شده برای وضعیت ، غیر قابل قبول است.");
        }
        if($gift_expire_timing !== "day" && $gift_expire_timing !== "hour"){
            $this->set_error("مقدار انتخاب شده برای نوع زمان انقضا جایزه ، غیر قابل قبول است.");
        }
        if(!empty($gift_image_id) && !Yooz_Manager_Utils::get_file_by_id($gift_image_id)){
            $this->set_error("تصویر جایزه ، معتبر نیست.");
        }
        if($gift_ID === false || !is_numeric($gift_ID)){
            $this->set_error("شناسه جایزه نامعتبر است.");
        }
        if($gift_expire_time === false || !is_numeric($gift_expire_time) || !is_int($gift_expire_time)){
            $this->set_error("زمان شارژ انقضا جایزه نامعتبر است.");
        }

        if(!$this->has_error()) {
            $result = $model->add_gift($gift_ID, $gift_name, $gift_description, $gift_claim_description,
                                        $required_coins, $gift_expire_time, $gift_expire_timing,
                                        $gift_image_id ,$gift_status);
            if($result){
                $structure = $model->get_gifts_ui();
                $response = ["response_type"=> "success" , "message" => "اطلاعات با موفقیت ذخیره شد." , "structure" => $structure['structure']];
            }else{
                $this->set_error($model->get_errors_text());
            }
        }
        return $response;
    }
    private function delete_gift_ajax(){
        $response = [];
        if(!empty($_POST['gift_ID'])){
            $gift_ID = intval($_POST['gift_ID']);
            $model = new Gifts_Model();
            if($model->delete_gift_item($gift_ID)){
                $structure = $model->get_gifts_ui();
                $response = ['response_type' => 'success' , 'message' => 'آیتم با موفقیت حذف شد.', "structure" => $structure['structure']];
            }else{
                $this->set_error("عملیات ناموفق. دوباره تلاش کنید.");
            }
        }else{
            $this->set_error("شناسه جایزه معتبر نیست.");
        }
        return $response;
    }


    private function get_event_info_ajax(){
        $response = [];
        if(isset($_POST['event_ID'])){
            $event_ID = intval($_POST['event_ID']);
            $model = new Events_Model();
            $result = $model->get_event_by_id($event_ID);
            if($event_ID == 0){
                $result = [
                    'event_ID'               => $event_ID,
                    "image_url"             => "/public/uploads/emptyImage.jpg",
                    'event_status'        => "yes",
                ];
            }
            if($result){
                if(!empty($result['event_expire'])){
                    $timestamp = strtotime($result['event_expire']);
                    $j_date = JDate::getDate($timestamp, "", "UTC");
                    $result['event_expire[year]']    = $j_date['year'];
                    $result['event_expire[month]']   = $j_date['mon'];
                    $result['event_expire[day]']     = $j_date['mday'];
                }
                $response = ["response_type"=>"success" , "message" => $result];
            }else{
                $this->set_error("شناسه رویداد وارد نشده است.");
            }
        }else{
            $this->set_error("شناسه رویداد وارد نشده است.");
        }
        return $response;
    }

    private function save_event_ajax(){
        $response = [];
        $model = new Events_Model();
        $event_ID               = isset($_POST['event_ID']) ? Utils::test_input($_POST['event_ID']) : false;
        $event_title            = !empty($_POST['event_title']) ? Utils::test_input($_POST['event_title']) : "";
        $event_name             = !empty($_POST['event_name']) ? Utils::test_input($_POST['event_name']) : "";
        $event_description      = !empty($_POST['event_description']) ? Utils::test_input($_POST['event_description']) : "";
        $required_coins         = !empty($_POST['required_coins']) ? intval(Utils::EnglishNumber($_POST['required_coins'])) : 0;
        $event_expire           = !empty($_POST['event_expire']) && is_array($_POST['event_expire']) ? $_POST['event_expire'] : [];
        $event_image_id         = !empty($_POST['event_image_id']) ? intval($_POST['event_image_id']) : 0;
        $event_status           = !empty($_POST['event_status']) ? Utils::test_input($_POST['event_status']) : "yes";

        /* validate data */
        if(empty($event_name) || empty($event_description) || empty($required_coins) || empty($event_title)){
            $this->set_error("تمامی اطلاعات خواسته شده را تکمیل نمایید.");
        }
        if($event_status !== "yes" && $event_status !== "no"){
            $this->set_error("مقدار انتخاب شده برای وضعیت ، غیر قابل قبول است.");
        }
        if(!empty($event_image_id) && !Yooz_Manager_Utils::get_file_by_id($event_image_id)){
            $this->set_error("تصویر رویداد ، معتبر نیست.");
        }
        if($event_ID === false || !is_numeric($event_ID)){
            $this->set_error("شناسه رویداد نامعتبر است.");
        }
        $expire_date = date("Y-m-d");
        if(!empty($event_expire['year']) && is_numeric($event_expire['year']) && !empty($event_expire['month']) && is_numeric($event_expire['month']) && !empty($event_expire['day']) && is_numeric($event_expire['day'])){
            $expire_date = JDate::to_greg_date(intval($event_expire['year']) , intval($event_expire['month']) , intval($event_expire['day']) , 23 , 59 , 59);
        }else{
            $this->set_error("تاریخ انقضای رویداد را انتخاب کنی.");
        }

        if(!$this->has_error()) {
            $result = $model->add_event($event_ID ,$event_title , $event_name, $event_description, $required_coins , $expire_date , $event_image_id, $event_status);
            if($result){
                $structure = $model->get_events_ui();
                $response = ["response_type"=> "success" , "message" => "اطلاعات با موفقیت ذخیره شد." , "structure" => $structure['structure']];
            }else{
                $this->set_error($model->get_errors_text());
            }
        }
        return $response;
    }

    private function delete_event_ajax(){
        $response = [];
        if(!empty($_POST['event_ID']) && is_numeric($_POST['event_ID'])){
            $event_ID = intval($_POST['event_ID']);
            $model = new Events_Model();
            if($model->delete_event_item($event_ID)){
                $structure = $model->get_events_ui();
                $response = ['response_type' => 'success' , 'message' => 'آیتم با موفقیت حذف شد.', "structure" => $structure['structure']];
            }else{
                $this->set_error("عملیات ناموفق! دوباره تلاش کنید.");
            }
        }else{
            $this->set_error("شناسه رویداد نامعتبر است.");
        }
        return $response;
    }
    private function lottery_ajax(){
        $response = [];
        if(!empty($_POST['lottery_members']) && !is_array($_POST['lottery_members'])){
            $model = new Lottery_Model();
            $lottery_members = Utils::test_input($_POST['lottery_members']);

            $users = [];
            if($lottery_members == "last_month_medalists") {
                $users = $model->get_last_month_medalists();
            } elseif ($lottery_members == "medalists") {
                $users = $model->get_all_medalists();
            } else {
                $users = $model->get_all_users();
            }
//            if($lottery_members == "all"){
//                $users = $model->get_all_users();
//            }elseif($lottery_members == "last_month_medalists"){
//                $users = $model->get_last_month_medalists();
//            }elseif($lottery_members == "medalists"){
//                $users = $model->get_all_medalists();
//            }elseif(is_numeric($lottery_members)){
//                $users = $model->get_users_with_gift(intval($lottery_members));
//            }

            if($lottery_members == "filtered") {
                $users = $model->get_all_players();
                if(!empty($users) && is_array($users)){
                    foreach ($users as $id => $user){
                        if($user && is_array($user) && !empty($user['user_register_date'])) {
                            if(!empty($_POST['min_coins']) && $_POST['min_coins'] > $user['coins_number']){
                                if(!empty($users[$id])) unset($users[$id]);
                            }
                            if (!empty($_POST['max_coins']) && $_POST['max_coins'] < $user['coins_number']) {
                                if(!empty($users[$id])) unset($users[$id]);
                            }
                            if (!empty($_POST['register_from']) && is_array($_POST['register_from'])) {
                                $register_from = $this->get_register_date($_POST['register_from']);
                                if(!empty($register_from) && strtotime($register_from) > strtotime($user['user_register_date'])) {
                                    if(!empty($users[$id])) unset($users[$id]);
                                }
                            }
                            if (!empty($_POST['register_until']) && is_array($_POST['register_until'])) {
                                $register_until = $this->get_register_date($_POST['register_until']);
                                if(!empty($register_until) && strtotime($register_until) < strtotime($user['user_register_date'])) {
                                    if(!empty($users[$id])) unset($users[$id]);
                                }
                            }
                            if (!empty($_POST['has_missions']) && (empty($user['missions']) || !array_key_exists($_POST['has_missions'] , $user['missions']))) {
                                if(!empty($users[$id])) unset($users[$id]);
                            }
                            if (!empty($_POST['has_gifts']) && (empty($user['gifts']) || !array_key_exists($_POST['has_gifts'] , $user['gifts']))) {

                                if(!empty($users[$id])) unset($users[$id]);
                            }
                        }
                    }
                }
            }
            //var_dump(count($users));die();
            if(count($users) > 0){
                $winner = $model->draw($users);
                if(!empty($winner)){
                    $response = [
                        'response_type' => 'success',
                        'message'       => $winner,
                    ];
                }else{
                    $this->set_error("شماره موبایل کاربران منطبق یافت نشد!.");
                }
            }else{
                $this->set_error("هیچ کاربر مطابقی یافت نشد.");
            }

        }else{
            $this->set_error("انتخاب کنید قرعه کشی از بین چه افرادی باشد.");
        }
        return $response;
    }

    private function get_register_date(array $date): string{
        $response = "";
        if (!empty($date['year']) && is_numeric($date['year']) && !empty($date['month']) && is_numeric($date['month']) && !empty($date['day']) && is_numeric($date['day'])) {
            $response = JDate::to_greg_date(intval($date['year']), intval($date['month']), intval($date['day']), null, null, null, "Y-m-d");
        }
        return $response;
    }

}