<?php
namespace App\Controllers\Admin;
use App\Models\Cards_Model;
use App\Models\Guess_Model;
use App\Models\Missions_Model;
use Core\Controller;
use Core\ErrorsTrait;
use Core\JDate;
use Core\Site_Options;
use Core\Utils;
use Core\Validators\Color_Validator;
use Core\Validators\Url_Validator;
use Plugins\Yooz_Manager\Yooz_Manager_Utils;

class Game_Rules_Controller extends Controller{
    use ErrorsTrait;
    public function index(){
        $mainRules = Site_Options::get("_yooz_main_game_rules");
        $medalRules = Site_Options::get("_yooz_game_medal_rules");
        $data = [
            'page_title'    => "قوانین کلی بازی",
            'main_rules'    => !empty($mainRules) && is_array(unserialize($mainRules)) ? unserialize($mainRules) : [],
            'medal_rules'   => !empty($medalRules) && is_array(unserialize($medalRules)) ? unserialize($medalRules) : [],
        ];

        $this->view->render("game_rules" , $data);
    }

    public function ajax_response(string $action){
        $response = [];
        $method_name = $action."_ajax";
        if(method_exists(self::class , $method_name)){
            $response = $this->$method_name();
        }
        if($this->has_error()){
            $response = ['response_type'=>'error' , 'message'=>$this->get_errors_text("<br>")];
        }
        return $response;
    }

    private function main_rules_ajax(){
        $data = $response = [];
        $data['registration_gift'] =    !empty($_POST['registration_gift']) ? intval(Utils::EnglishNumber($_POST['registration_gift'])) : 0;
        $data['invitation_gift'] =      !empty($_POST['invitation_gift']) ? intval(Utils::EnglishNumber($_POST['invitation_gift'])) : 0;
        $data['daily_gift'] =           !empty($_POST['daily_gift']) ? intval(Utils::EnglishNumber($_POST['daily_gift'])) : 0;
        $data['birthdate_gift'] =       !empty($_POST['birthdate_gift']) ? intval(Utils::EnglishNumber($_POST['birthdate_gift'])) : 0;
        $data['profile_gift'] =         !empty($_POST['profile_gift']) ? intval(Utils::EnglishNumber($_POST['profile_gift'])) : 0;

        $result = Site_Options::update("_yooz_main_game_rules" , serialize($data));
        if($result){
            $response = ['response_type' => "message" , "message"=>"اطلاعات با موفقیت به روز رسانی شد."];
        }else{
            $this->set_error("عملیات ناموفق! دوباره تلاش کنید.");
        }
        return $response;
    }

    private function medal_rules_ajax(){
        $data = $response = $errors = [];

        $data['medals_activation'] =                !empty($_POST['medals_activation']) ? Utils::test_input($_POST['medals_activation']) : "yes";
        $data['display_top_users'] =                !empty($_POST['display_top_users']) ? Utils::test_input($_POST['display_top_users']) : "yes";
        $data['get_medal_needed_coins'] =           !empty($_POST['get_medal_needed_coins']) ? intval(Utils::EnglishNumber($_POST['get_medal_needed_coins'])) : 0;

        $data['medal_cond_image'] = !empty($_POST['medal_cond_image']) && is_numeric($_POST['medal_cond_image']) ? intval($_POST['medal_cond_image']) : 0;
        $data['medal_cond_descriptions'] = !empty($_POST['medal_cond_descriptions']) ? Utils::test_input($_POST['medal_cond_descriptions']) : "";
        $data['medal_win_image'] = !empty($_POST['medal_win_image']) && is_numeric($_POST['medal_win_image']) ? intval($_POST['medal_win_image']) : 0;
        $data['medal_win_descriptions'] = !empty($_POST['medal_win_descriptions']) ? Utils::test_input($_POST['medal_win_descriptions']) : "";


        /* validation data */
        if($data['medals_activation'] !== "yes" && $data['medals_activation'] !== "no"){
            array_push($errors , "مقدار انتخاب شده برای 'فعال بودن مدال‌ها' ، غیر قابل قبول است.");
        }
        if($data['display_top_users'] !== "yes" && $data['display_top_users'] !== "no"){
            array_push($errors , "مقدار انتخاب شده برای 'فعال بودن نمایش مدال آوران' ، غیر قابل قبول است.");
        }
//        if(!Yooz_Manager_Utils::get_file_by_id($data['medal_cond_image'])){
//            array_push($errors , "تصویر وارد شده برای آیکون مدال معتبر نیست.");
//        }
//        if(!Yooz_Manager_Utils::get_file_by_id($data['medal_win_image'])){
//            array_push($errors , "تصویر وارد شده برای آیکون برنده شدن مدال معتبر نیست.");
//        }


        if(count($errors) == 0){
            $result = Site_Options::update("_yooz_game_medal_rules" , serialize($data));
            if($result){
                $response = ['response_type' => "message" , "message"=>"اطلاعات با موفقیت به روز رسانی شد."];
            }else{
                $this->set_error("عملیات ناموفق! دوباره تلاش کنید.");
            }
        }

        if(count($errors) > 0){
            $responseText = "خطا :"."<br>";
            $responseText .= implode("<br>" , $errors);
            $response = ["response_type"=>"error" , "message" => $responseText];
        }

        return $response;
    }
}