<?php
namespace App\Controllers\Admin;
use App\Models\UserModel;
use Core\Controller;
class Home_Controller extends Controller{
    public function index(){
        $usersModel = new UserModel();
        /* get number of users */
        $usersCount = $usersModel->users_count();
        /* get the non invited users in last month */
        $oneMonthAgo = date("Y-m-d" , strtotime("-1 months"));
        $lastMonthInvitedUsers = $usersModel->users_count("inviter_ID > 0 AND user_register_date <= NOW() AND user_register_date > '$oneMonthAgo'");
        /* get the non invited users in last month */
        $lastMonthNIdUsers = $usersModel->users_count("inviter_ID='0' AND user_register_date <= NOW() AND user_register_date > '$oneMonthAgo'");
        /* get the users all coins */
        $user_coins = $usersModel->get_users_coins();
        /* last 5 registered users */
        $lastRegisteredUsers = $usersModel->get_users("user_ID IS NOT NULL ORDER BY user_ID DESC" , "5");
        /* get top 5 users */
        $top5Users = $usersModel->get_users("user_ID IS NOT NULL ORDER BY total_score DESC , user_ID ASC" , "5");


        $data = [
            'page_title'            => "پنل مدیریت",
            'users_count'           => $usersCount,
            'lastMonthInvitedUsers' => $lastMonthInvitedUsers,
            'lastMonthNIdUsers'     => $lastMonthNIdUsers,
            'user_coins'            => $user_coins,
            'lastRegisteredUsers'   => $lastRegisteredUsers,
            'top5Users'             => $top5Users,
        ];
        $this->view->render('home' , $data);
    }
}