<?php
namespace App\Controllers\Admin;
use App\Models\Cards_Model;
use App\Models\Interactive_Messages_Model;
use App\Models\Missions_Model;
use App\Models\Gifts_Model;
use Core\Controller;
use Core\ErrorsTrait;
use Core\JDate;
use Core\Site_Options;
use Core\Utils;
use Plugins\Yooz_Manager\Yooz_Manager_Utils;

class Message_Settings_Controller extends Controller{
    use ErrorsTrait;
    private array $default_messages = ['birthdate_message_notif'=>'تبریک تولد','welcome_message_notif'=>'پیام خوش آمد گویی'];
    public function index(){
//        $allCards = $allMissions = [];
//        $cardsModel = new Cards_Model();
//        $cards = $cardsModel->get_cards();
//        if($cards && is_array($cards)){
//            foreach ($cards as $card){
//                $allCards[$card['card_ID']] = $card['card_name'];
//            }
//        }

        $missionModel = new Missions_Model();
        $missions = $missionModel->get_missions();
        $allMissions = array();
        if($missions && is_array($missions)){
            foreach ($missions as $mission){
                $allMissions[$mission['mission_ID']] = $mission['mission_title'];
            }
        }

        $giftsModel = new Gifts_Model();
        $gifts = $giftsModel->get_gifts();
        $allGifts = array();
        if($gifts && is_array($gifts)){
            foreach ($gifts as $gift){
                $allGifts[$gift['gift_ID']] = $gift['gift_name'];
            }
        }

        $messageModel = new Interactive_Messages_Model();
        $messages = $messageModel->get_messages();

        $data = [
            'page_title'        => "مدیریت پیام‌های درون برنامه‌ای",
            'default_messages'  => $this->default_messages,
//            'all_cards'         => $allCards,
            'all_missions'      => $allMissions,
            'all_gifts'      => $allGifts,
            'all_messages'      => $messages && is_array($messages) ? $messages : [],
        ];
        $this->view->render('message_settings' , $data);
    }

    public function ajax_response(string $action){
        $response = [];
        $method_name = $action."_ajax";
        if(method_exists(self::class , $method_name)){
            $response = $this->$method_name();
        }

        if($this->has_error()){
            $response = ['response_type'=>'error' , 'message'=>$this->get_errors_text()];
        }

        return $response;
    }

    private function get_default_message_ajax(): array{
        $response = [];
        if(!empty($_POST['message_key']) && array_key_exists($_POST['message_key'] , $this->default_messages)){
            $message_key = Utils::test_input($_POST['message_key']);
            $result = Site_Options::get($message_key);
            if($result){
                $message = $result;
            }else{
                $message = "پیام ارسال شده یافت نشد. اکنون میتوانید متن آن را بنویسید سپس آن را ذخیره نمایید.";
            }
            $response = ['response_type'=>"success" , 'message'=>array("message_key"=>$message_key, "message_text"=>$message)];
        }else{
            $this->set_error("نوع پیام را انتخاب کنید.");
        }

        return $response;
    }

    private function save_default_message_ajax() : array{
        $response = [];
        if(!empty($_POST['message_key']) && array_key_exists($_POST['message_key'] , $this->default_messages)){
            if(!empty($_POST['message_text'])){
                $message_key = Utils::test_input($_POST['message_key']);
                $message_text = Utils::test_input($_POST['message_text']);
                $result = Site_Options::update($message_key , $message_text);
                if($result){
                    $response = ["response_type"=>"message" , "message"=>"متن پیام با موفقیت به روز رسانی شد."];
                }else{
                    $this->set_error("عملیات ناموفق! لطفا دوباره تلاش کنید.");
                }
            }else{
                $this->set_error("متن پیام را وارد کنید.");
            }
        }else{
            $this->set_error("نوع پیام را مشخص کنید. درصورت وجود مشکل مجددا روی نمایش پیام بزنید.");
        }
        return $response;
    }


    private function get_interactive_message_ajax() : array{
        $response = [];
        if(isset($_POST['message_ID'])){
            $messageID = intval($_POST['message_ID']);
            $model = new Interactive_Messages_Model();
            $result = $model->get_message_by_id($messageID);
            if($messageID == 0){
                $result = [
                    'message_ID'            => $messageID,
                    "image_url"             => "/public/uploads/emptyImage.jpg",
                    'register_from[year]'   => 0,
                    'register_from[month]'  => 0,
                    'register_from[day]'    => 0,
                    'register_until[year]'  => 0,
                    'register_until[month]' => 0,
                    'register_until[day]'   => 0,
                    'message_members'       => 'all',
                ];
            }
            if($result){
                $response = ["response_type"=>"success" , "message" => $result];
            }else{
                $this->set_error("شناسه کارت وارد نشده است.");
            }
        }
        return $response;
    }

    private function save_interactive_message_ajax(){
        $response = [];
        if(!empty($_POST['message_title']) && !empty($_POST['message_text'])){
            $message_ID     = !empty($_POST['message_ID']) ? intval(Utils::EnglishNumber($_POST['message_ID'])) : 0;
            $message_title  = Utils::test_input($_POST['message_title']);
            $message_text   = Utils::test_input($_POST['message_text']);
            $gift_coins     = !empty($_POST['gift_coins']) ? intval(Utils::EnglishNumber($_POST['gift_coins'])) : 0;
            $image_id       = !empty($_POST['message_image_id']) ? Utils::test_input(Utils::EnglishNumber($_POST['message_image_id'])) : 0;
            $display_status = !empty($_POST['display_status']) ? Utils::test_input($_POST['display_status']) : "yes";
            $members        = !empty($_POST['message_members']) ? Utils::test_input($_POST['message_members']) : "all";

            /*neccesary inputs validation*/
            if($image_id !== 0 && (!is_numeric($image_id) || !Yooz_Manager_Utils::get_file_by_id($image_id))){
                $this->set_error("تصویر انتخاب شده برای پیام نامعتبر است.");
            }
            if($display_status !== "yes" && $display_status !== "no"){
                array_push($errors , "مقدار انتخاب شده برای وضعیت ، غیر قابل قبول است.");
            }
            $accept_members_type = ['all','medalists','last_month_medalists','filtered'];
            if(!in_array($members , $accept_members_type)){
                $members = "all";
                array_push($errors , "مقدار انتخاب شده برای افراد گیرنده پیام نامعتبر است.");
            }
            
            
            

            /*get the filters*/
            $cond = [];
            $cond['message_members'] = $members;
            $cond['min_coins'] = !empty($_POST['min_coins']) ? intval(Utils::EnglishNumber($_POST['min_coins'])) : 0;
            $cond['max_coins'] = !empty($_POST['max_coins']) ? intval(Utils::EnglishNumber($_POST['max_coins'])) : 0;
//            $has_cards = !empty($_POST['has_cards']) && is_array($_POST['has_cards']) ? $_POST['has_cards'] : [];
            $has_missions = !empty($_POST['has_missions']) ? array($_POST['has_missions']) : [];
            $has_gifts = !empty($_POST['has_gifts']) ? array($_POST['has_gifts']) : [];
            $register_from = !empty($_POST['register_from']) && is_array($_POST['register_from']) ? $_POST['register_from'] : [];
            $register_until = !empty($_POST['register_until']) && is_array($_POST['register_until']) ? $_POST['register_until'] : [];


//            $allCards = $allMissions = $allGifts = [];
//            $cardsModel = new Cards_Model();
            $missionModel = new Missions_Model();
            $giftsModel = new Gifts_Model();
//            $cards = $cardsModel->get_cards();
//            if($cards && is_array($cards)){
//                foreach ($cards as $card){$allCards[] = $card['card_ID'];}
//            }
            $missions = $missionModel->get_missions();
            if($missions && is_array($missions)){
                foreach ($missions as $mission){$allMissions[] = $mission['mission_ID'];}
            }
            $gifts = $giftsModel->get_gifts();
            if($gifts && is_array($gifts)){
                foreach ($gifts as $gift){$allGifts[] = $gift['gift_ID'];}
            }

            /*validate filters*/
//            if(!empty($has_cards) && !empty($allCards)){
//                $cardsCheck = array_intersect($allCards, $has_cards);
//                if(count($cardsCheck) !== count($has_cards)){
//                    $this->set_error("برخی از کارت‌های انتخاب شده یافت نمی‌شوند.");
//                }else{
//                    $cond['has_cards'] = $has_cards;
//                }
//            }

            if(!empty($has_missions) && !empty($allMissions)){
                $missionsCheck = array_intersect($allMissions, $has_missions);

                if(count($missionsCheck) !== count($has_missions)){
                    $this->set_error("برخی از ماموریت‌های انتخاب شده یافت نمی‌شوند.");
                }else{
                    $cond['has_missions'] = $has_missions;
                }
            }
            if(!empty($has_gifts) && !empty($allGifts)){
                $giftCheck = array_intersect($allGifts, $has_gifts);
                if(count($giftCheck) !== count($has_gifts)){
                    $this->set_error("برخی از کارت‌های انتخاب شده یافت نمی‌شوند.");
                }else{
                    $cond['has_gifts'] = $has_gifts;
                }
            }

            $cond['register_date_from'] = $this->get_register_date($register_from);
            $cond['register_date_until'] = $this->get_register_date($register_until);
            if(!empty($cond['register_date_from']) && !empty($cond['register_date_until'])){
                if(strtotime($cond['register_date_from']) > strtotime($cond['register_date_until'])){
                    $this->set_error("تاریخ آغاز ثبت نام نباید پس از تاریخ نهایی باشد.");
                }
            }

            if(!$this->has_error()){
                $messageModel = new Interactive_Messages_Model();
                $result = $messageModel->add_message($message_ID , $message_title , $message_text , $gift_coins , $cond , $image_id);
                if($result){
                    $structure = $messageModel->get_messages_ui();
                    $response = [
                        'response_type' =>'success',
                        'message'       => 'عملیات با موفقیت انجام شد.',
                        'structure'     => $structure['structure']];
                }else{
                    $this->set_error($messageModel->get_errors_text());
                }
            }

        }else{
            $this->set_error("وارد کردن عنوان و متن پیام الزامی است.");
        }
        return $response;
    }

    /**
     * @param array $date
     * @return string
     */
    private function get_register_date(array $date): string{
        $response = "";
        if (!empty($date['year']) && is_numeric($date['year']) && !empty($date['month']) && is_numeric($date['month']) && !empty($date['day']) && is_numeric($date['day'])) {
            $response = JDate::to_greg_date(intval($date['year']), intval($date['month']), intval($date['day']), null, null, null, "Y-m-d");
        }
        return $response;
    }

    private function delete_interactive_message_ajax(){
        $response = [];
        if(!empty($_POST['message_ID'])){
            $messageID = intval($_POST['message_ID']);
            $model = new Interactive_Messages_Model();
            if($model->delete_message_item($messageID)){
                $structure = $model->get_messages_ui();
                $response = ['response_type' => 'success' , 'message' => 'آیتم با موفقیت حذف شد.', "structure" => $structure['structure']];
            }else{
                $this->set_error("عملیات ناموفق. دوباره تلاش کنید.");
            }
        }else{
            $this->set_error("شناسه پیام معتبر نیست.");
        }
        return $response;
    }

}