<?php
namespace App\Controllers\Admin;
class Sidebar_Controller{
    private $menu_items = [];

    public function __construct(){
        self::default_menu_items();
        self::sort_menus($this->menu_items);
    }

    public function index(){
        $yooz_menu_items = $this->menu_items;
        require_once dirname(__FILE__)."/../../Views/Admin/sidebar.php";
    }

    private function sort_menus(array &$menu){
        if(is_array($menu)){
            self::usort_menus($menu);
            foreach ($menu as $key => $item){
                if(isset($item['childs']) && is_array($item['childs']) && count($item['childs']) > 0){
                    self::sort_menus($menu[$key]['childs']);
                }
            }
        }
    }
    private function usort_menus(array &$menu){
        usort($menu , function ($a , $b){
            if(!empty($a['values']['position']) && !empty($b['values']['position']) && is_numeric($a['values']['position']) && is_numeric($b['values']['position'])){
                if($a['values']['position'] == $b['values']['position']) return 0;
                return ($a['values']['position'] < $b['values']['position']) ? -1 : 1;
            }else{
                return 0;
            }
        });
    }
    private function add_menu_item(array $args){
        if(!empty($args['menu_slug']) && !empty($args['menu_name'])){
            $args['menu_url'] = empty($args['menu_url']) ? ADMIN_URL."/".$args['menu_slug'] : $args['menu_url'];
            if(!empty($args['parent_slug'])){
                self::add_child_menu_item($args , $this->menu_items);
            }else{
                $this->menu_items[$args['menu_slug']]['nested_level'] = 1;
                $args['position'] = !isset($args['position']) ? count($this->menu_items) + 1 : $args['position'];
                $this->menu_items[$args['menu_slug']]['values'] = $args;
            }
        }
    }

    private function add_child_menu_item(array $menu_item , &$array , $nested_level = 1){
        if(is_array($array)){
            $nested_level++;
            foreach ($array as $key => $value){
                if($key === $menu_item['parent_slug']){
                    $array[$key]['childs'][$menu_item['menu_slug']]['nested_level'] = $nested_level;
                    if(!isset($menu_item['position'])){
                        $menu_item['position'] = is_array($array[$key]['childs']) ? count($array[$key]['childs']) + 1 : 1;
                    }
                    $array[$key]['childs'][$menu_item['menu_slug']]['values'] = $menu_item;
                    break;
                }else{
                    if(isset($value['childs']) && is_array($value['childs']) && count($value['childs']) > 0){
                        self::add_child_menu_item($menu_item , $array[$key]['childs'] , $nested_level);
                    }
                }
            }
        }
    }

    private function default_menu_items(){
        self::add_menu_item(array(
            "menu_slug"     =>  "admin_panel",
            "menu_name"     =>  "پیشخوان",
            "menu_icon"     =>  "tachometer-alt-fast",
            "menu_url"      =>  ADMIN_URL
        ));
        self::add_menu_item(array(
            "menu_slug"     =>  "game_rules",
            "menu_name"     =>  "قوانین کلی",
            "menu_icon"     =>  "box-open",
        ));
        self::add_menu_item(array(
            "menu_slug"     =>  "game_coins",
            "menu_name"     =>  "تعریف سکه‌ها",
            'menu_icon'     =>  "coin",
        ));
        self::add_menu_item(array(
            "menu_slug"     =>  "game_gifts",
            "menu_name"     =>  "تعریف جایزه‌ها",
            'menu_icon'     =>  "gift",
        ));
        self::add_menu_item(array(
            "menu_slug"     =>  "messages_setting",
            "menu_name"     =>  "تنظیمات پیام‌ها",
            'menu_icon'     =>  "paper-plane",
        ));
        self::add_menu_item(array(
            "menu_slug"     =>  "customers",
            "menu_name"     =>  "مشتریان",
            'menu_icon'     =>  "user",
        ));
        self::add_menu_item(array(
            "menu_slug"     =>  "settings",
            "menu_name"     =>  "تنظیمات",
            "menu_icon"     =>  "tools",
            "position"      =>  10000,
        ));
        self::add_menu_item(array(
            "menu_slug"     =>  "store_settings",
            "menu_name"     =>  "تنظیمات فروشگاه",
            "menu_icon"     =>  "tools",
            "parent_slug"   =>  'settings',
        ));
        self::add_menu_item(array(
            "menu_slug"     =>  "game_settings",
            "menu_name"     =>  "تنظیمات بازی",
            "menu_icon"     =>  "tools",
            "parent_slug"   =>  'settings',
        ));
    }
}
?>