<?php
namespace App\Controllers\Website;
use App\Models\UserModel;
use Core\Controller;
use Core\Router;
use Core\Utils;

class Home_Controller extends Controller{

    public function index(): void
    {
        if(!empty($_GET['inviter'])){
            $rawInviter = Utils::test_input($_GET['inviter']);
            $inviter = @base64_decode(@hex2bin($rawInviter));
            if(!empty($inviter) && is_numeric($inviter)){
                setcookie("inviter" , $rawInviter, time() + (60 * 60 * 24 * 30) , "/");
            }
        }
        $userModel = new UserModel();
        $user = $userModel->get_current_user();
        if($user && is_array($user) && !empty($user['user_ID'])){
            define("CURRENT_USER" , $user);
            Router::set_route_slug("website_game");
            $class = new Game_Controller();
        }else{
            Router::set_route_slug("website_home");
            $class = new Lander_Controller();
        }
        $class->index();
    }
}