<?php
namespace App\Controllers\Website;

use App\Models\Game_Model;
use App\Models\UserModel;
use Core\Avatars;
use Core\Controller;
use Core\ErrorsTrait;
use Core\Site_Options;
use Core\Utils;
use Core\Validators\Phone_Validator;

class Login_Controller extends Controller{
    use ErrorsTrait;

    public function login_page(){
        $lander_settings = Site_Options::get("_lander_settings");
        $userModel = new UserModel();
        $user = $userModel->get_current_user();
        if($user && is_array($user)){
            header("Location: ".HOME_URL);
        }else{
            $data = [
                'page_title' => 'صفحه ورود کاربر',
                'lander_settings' => $lander_settings && is_array(unserialize($lander_settings)) ? unserialize($lander_settings) : [],
            ];
            $this->view->render('login_page' , $data , false);
        }
    }

    public function register_page(){
        $lander_settings = Site_Options::get("_lander_settings");
        $userModel = new UserModel();
        $user = $userModel->get_current_user();
        if($user && is_array($user)){
            header("Location: ".HOME_URL);
        }else{
            if(!empty($_GET['token'])){
                $token = Utils::test_input($_GET['token']);
                $userModel = new UserModel();
                $user = $userModel->get_user("otp_token='$token'");
                if(!empty($user) && is_array($user)){
                    if(strtotime($user['otp_expire']) >= time()){
                        $data = [
                            'page_title'    => 'صفحه ثبت نام کاربران',
                            'lander_settings' => $lander_settings && is_array(unserialize($lander_settings)) ? unserialize($lander_settings) : [],
                            'user'          => $user,
                            'token'         => $token,
                        ];
                        $this->view->render("register_page" , $data , false);
                    }else{
                        $this->set_error("توکن امنیتی منقضی شده است.");
                    }
                }else{
                    $this->set_error("توکن امنیتی اشتباه است.");
                }
            }else{
                $this->set_error("توکن امنیتی وارد نشده است.");
            }

            if($this->has_error()){
                $message = $this->get_errors_text();
                echo '<script>alert("'.$message.'");history.go(-1);</script>';
            }
        }
    }

    public function authenticate_page(){
        $lander_settings = Site_Options::get("_lander_settings");
        $userModel = new UserModel();
        $user = $userModel->get_current_user();
        if($user && is_array($user)){
            header("Location: ".HOME_URL);
        }else{
            if(!empty($_GET['token'])){
                $token = Utils::test_input($_GET['token']);
                $userModel = new UserModel();
                $user = $userModel->get_user("otp_token='$token'");
                if(!empty($user) && is_array($user)){
                    if(strtotime($user['otp_expire']) >= time()){
                        $data = [
                            'page_title'    => 'صفحه ورود کاربران',
                            'lander_settings' => $lander_settings && is_array(unserialize($lander_settings)) ? unserialize($lander_settings) : [],
                            'user'          => $user,
                            'token'         => $token,
                        ];
                        $this->view->render("authenticate_page" , $data , false);
                    }else{
                        $this->set_error("توکن امنیتی منقضی شده است.");
                    }
                }else{
                    $this->set_error("توکن امنیتی اشتباه است.");
                }
            }else{
                $this->set_error("توکن امنیتی وارد نشده است.");
            }

            if($this->has_error()){
                $message = $this->get_errors_text();
                echo '<script>alert("'.$message.'");history.go(-1);</script>';
            }
        }
    }

    public function ajax_response(string $action){
        $response = [];
        $method_name = $action."_ajax";
        if(method_exists(self::class , $method_name)){
            $response = $this->$method_name();
        }
        if($this->has_error()){
            $response = ['response_type'=>'error' , 'message'=>$this->get_errors_text()];
        }
        return $response;
    }

    private function login_ajax(){
        $response = [];
        if(!empty($_POST['phone'])){
            $phone = Utils::test_input($_POST['phone']);
            $validator = new Phone_Validator();
            if($validator->validate($phone)){
                $userModel = new UserModel();
                $user = $userModel->get_user("phone='$phone'");
                if(!empty($user) && is_array($user)){
                    $token = $userModel->authenticate_user($phone);
                    if($token){
                        if(!empty($user['display_name'])){
                            $redirect_url = SITE_URL."/authenticate?token=".$token;
                        }else{
                            $redirect_url = SITE_URL."/register?token=".$token;
                        }
                        $response = [
                            'response_type' => 'redirect',
                            'redirect_url'  => $redirect_url,
                        ];
                    }else{
                        $this->set_error($userModel->get_errors_text("<br>"));
                    }

                }else{// new user
                    $token = $userModel->register_user($phone);
                    if($token){
                        $response = [
                            'response_type' => 'redirect',
                            'redirect_url'  => SITE_URL."/register?token=".$token,
                        ];
                    }else{
                        $this->set_error($userModel->get_errors_text("<br>"));
                    }
                }
            }else{
                $this->set_error("شماره موبایل بای با ۰۹ آغاز شود و شامل ۱۱ رقم باشد.");
            }
        }else{
            $this->set_error("شماره موبایل خود را وارد کنید.");
        }
        return $response;
    }

    private function register_ajax(){
        $response = [];
        if(!empty($_POST['token'])){
            if(!empty($_POST['display_name']) && !empty($_POST['otp_code'])){
                if(!empty($_POST['profile_avatar']) && is_numeric($_POST['profile_avatar'])){
                    $avatars = Avatars::$avatars;
                    if(array_key_exists($_POST['profile_avatar'] , $avatars)){
                        $avatarID = intval($_POST['profile_avatar']);
                        $displaye_name = Utils::test_input($_POST['display_name']);
                        $otp_code = Utils::test_input($_POST['otp_code']);
                        $token = Utils::test_input($_POST['token']);

                        $userModel = new UserModel();
                        $user = $userModel->get_user("otp_token='$token'");
                        if($user && is_array($user) && !empty($user['user_ID'])){
                            if(strtotime($user['otp_expire']) >= time()){
                                if($user['otp_code'] == $otp_code){
                                    $data = [
                                        'display_name'      => $displaye_name,
                                        'profile_image'     => $avatarID,
                                        'otp_code'          => '',
                                        'otp_token'         => '',
                                        'otp_expire'        => date("Y-m-d H:i:s" , strtotime("-1 days")),
                                        'user_register_date'=> date("Y-m-d"),
                                    ];
                                    $result = $userModel->set_user_data($data , intval($user['user_ID']));
                                    if($result){
                                        $login = $userModel->set_user_login($user['user_ID']);
                                        if($login){

                                            $gameModel = new Game_Model();
                                            $appSettings = Site_Options::get("_yooz_main_game_rules");
                                            if(!empty($appSettings) && is_array(unserialize($appSettings))){
                                                $appSettings = unserialize($appSettings);
                                                if(!empty($appSettings['registration_gift'])){
                                                    $gameModel->set_coins_to_user($user['user_ID'] , intval($appSettings['registration_gift']));
                                                }
                                                if(!empty($user['inviter_ID'])){
                                                    $notif_data = [
                                                        'user_ID'               => intval($user['inviter_ID']),
                                                        'message_title'    => "هدیه دعوت دوست",
                                                        'message_text'     => "دوست شما با نام ".$displaye_name." با استفاده از لینک دعوت شما، وارد بازی شد.",
                                                    ];
                                                    if(!empty($appSettings['invitation_gift'])){
                                                        $notif_data['gift_coins'] = intval($appSettings['invitation_gift']);
                                                    }
                                                    $gameModel->set_notification($notif_data);
                                                }
                                            }

                                            if(!empty($user['inviter_ID'])){
                                                $gameModel->set_user_scores(intval($user['inviter_ID']) , "invitation");
                                            }

                                            $gameModel->set_user_register_messages($user['user_ID']);



                                            $response = [
                                                'response_type' => 'redirect',
                                                'redirect_url'  => HOME_URL,
                                            ];
                                        }else{
                                            $this->set_error("خطایی پیش آمده است. لطفا به صفحه قبل بازکردید و دوباره تلاش کنید.");
                                        }
                                    }else{
                                        $this->set_error($userModel->get_errors_text("<br>"));
                                    }
                                }else{
                                    $this->set_error("کد تایید صحیح نیست!");
                                }
                            }else{
                                $this->set_error("توکن امنیتی منقضی شده است.");
                            }
                        }else{
                            $this->set_error("توکن امنیتی وارد شده اشتباه است.");
                        }
                    }else{
                        $this->set_error("آواتار انتخاب شده معتبر نیست.");
                    }
                }else{
                    $this->set_error("آواتار شبیه به خود را انتخاب کنید.");
                }
            }else{
                $this->set_error("اطلاعات خواسته شده را وارد کنید.");
            }
        }else{
            $this->set_error("توکن امنیتی وارد نشده است.");
        }
        return $response;
    }

    private function authenticate_ajax(){
        $response = [];
        if(!empty($_POST['token'])){
            if(!empty($_POST['otp_code'])){
                $otp_code = Utils::test_input($_POST['otp_code']);
                $token = Utils::test_input($_POST['token']);

                $userModel = new UserModel();
                $user = $userModel->get_user("otp_token='$token'");
                if($user && is_array($user) && !empty($user['user_ID'])){
                    if(strtotime($user['otp_expire']) >= time()){
                        if($user['otp_code'] == $otp_code){
                            $login = $userModel->set_user_login($user['user_ID']);
                            if($login){
                                $response = [
                                    'response_type' => 'redirect',
                                    'redirect_url'  => HOME_URL,
                                ];
                            }else{
                                $this->set_error("خطایی پیش آمده است. لطفا به صفحه قبل بازکردید و دوباره تلاش کنید.");
                            }
                        }else{
                            $this->set_error("کد تایید صحیح نیست!");
                        }
                    }else{
                        $this->set_error("توکن امنیتی منقضی شده است.");
                    }
                }else{
                    $this->set_error("توکن امنیتی وارد شده اشتباه است.");
                }
            }else{
                $this->set_error("کد تایید را وارد کنید.");
            }
        }else{
            $this->set_error("توکن امنیتی وارد نشده است.");
        }
        return $response;
    }
}