<?php
namespace App\Models;
use Core\ErrorsTrait;
use Core\Model;
use Core\Utils;


class Admin extends Model{
    use ErrorsTrait;
    private $users_table = "yooz_admins";
    /* set cookie _YAIDU_ mean Yooz Admin Session Token */
    private $cookie_name = '_YAST_';
    private $current_admin;


    public function get_admins(string $where_clause = "", string $limit = ""){
        $stmt = $this->db->select($this->users_table , "*" , $where_clause , $limit);
        if($stmt->rowCount() == 1){return $stmt->fetch();}
        if($stmt->rowCount() > 1){return $stmt->fetchAll();}
        return false;
    }
    public function is_login(){
        if(isset($_COOKIE[$this->cookie_name])){
            $cookieValue = Utils::test_input($_COOKIE[$this->cookie_name]);
            if(!empty($cookieValue)){
                $admin = $this->get_admins("session_token='$cookieValue'");
                if($admin && !empty($admin['admin_ID'])){
                    $this->current_admin = $admin;
                    return true;
                }
            }
        }
        return false;
    }

    public function get_current_admin(){
        if($this->is_login()){
            $admin = $this->current_admin;
            return is_array($admin) ? $admin : false;
        }
        return false;
    }

    public function hash_password($password){
        return md5($password);
    }

    public function update_admin(int $admin_ID , array $data){
        $db_cols = [
            'display_name','username','email','password','reset_password_token',
            'reset_token_expire','session_token','privileges','profile_image_id'
        ];
        foreach ($data as $key => $value){
            if(!in_array($key , $db_cols)){
                die("ستون وارد شده برای به روز رسانی ادمین ، در جدول وجود ندارد.");
            }
        }
        return $this->db->update($this->users_table , $data , "admin_ID='$admin_ID'");
    }

    /*
    * set cookie to check user information
    * the cookie value is encoded with bin2hex and base64_encode to prevent find information by anyone
    * $seprator is used to detect the id and username after decode the cookie value
    * */
    public function set_admin_login($adminID){
        $token = bin2hex(random_bytes(32)."*_".$adminID."_*".random_bytes(32));
        $stmt = $this->db->update($this->users_table , ['session_token'=>$token] , "admin_ID='$adminID'");
        if($stmt){
            setcookie($this->cookie_name , $token , time() + 86400 , "/");
            return true;
        }
        return false;
    }
    private function is_acceptable_password($password):bool{
        $pattern = "/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@!#$%^&*])[A-Za-z\d@!#$%^&*]{6,18}$/";
        return (bool)preg_match($pattern, $password);
    }
    public function logout_user(){
        setcookie($this->cookie_name , "" , time() - (86400 * 30) , "/");
    }
}