<?php
namespace App\Models;
use Core\ErrorsTrait;
use Core\Model;
use Plugins\Yooz_Manager\Yooz_Manager_Utils;

class Gifts_Model extends Model{
    use ErrorsTrait;
    private string $table_name = "yooz_game_gifts";
    public function get_gift_by_id(int $id){
        $response = false;
        $result = $this->db->select($this->table_name , "*" , "gift_ID='$id'");
        if($result && $result->rowCount() > 0){
            $response = $result->fetch();
            $image = Yooz_Manager_Utils::get_file_by_id($response['gift_image_id']);
            $response['image_url'] = $image && !empty($image['file_url']) ? $image['file_url'] : "/public/uploads/emptyImage.jpg";
        }
        return $response;
    }

    public function get_gifts(){
        $response = false;
        $result = $this->db->select($this->table_name , "*");
        if($result && $result->rowCount() > 0){
            $response = $result->fetchAll();
        }
        return $response;
    }
    public function get_gifts_ui(){
        require_once __DIR__."/../Views/Admin/template-parts/game_gifts/gift_card_item.php";
        $items = $this->get_gifts();
        $items = $items && is_array($items) ? $items : [];
        return get_gift_cards($items);
    }

    public function delete_gift_item(int $gift_ID){
        $result = $this->db->delete($this->table_name , "gift_ID='$gift_ID'");
        return (bool)$result;
    }

    public function add_gift($id,$name,$description,$claim_description,$required_coins ,$expire_time,$expire_timing,$image_id,$status){
        $data = [
            'gift_name'             => $name,
            'gift_description'      => $description,
            'gift_claim_description'=> $claim_description,
            'required_coins'        => $required_coins,
            'gift_expire_time'      => $expire_time,
            'gift_expire_timing'    => $expire_timing,
            'gift_image_id'         => $image_id,
            'gift_status'           => $status,
        ];
        if($id == 0){
            $card = $this->db->select($this->table_name , "*" , "gift_name='$name'");
            if($card->rowCount() > 0){
                $this->set_error("نام جایزه تکراری است. لطفا از نام دیگری استفاده کنید.");
                return false;
            }else{
                return $this->db->insert($this->table_name , $data);
            }
        }
        if($id > 0){
            return $this->db->update($this->table_name , $data , "gift_ID='$id'");
        }
        return false;
    }
}