<?php
namespace App\Models;
use Core\ErrorsTrait;
use Core\JDate;
use Core\Model;
use App\Models\UserModel;
use App\Models\Game_Model;
use Plugins\Yooz_Manager\Yooz_Manager_Utils;

class Interactive_Messages_Model extends Model{
    use ErrorsTrait;
    private $table_name = "yooz_interactive_messages";
    private $notification_table = "yooz_user_notifications";
    
    public function get_message_by_id(int $message_ID){
        $response = false;
        $result = $this->db->select($this->table_name , "*" , "message_ID='$message_ID'");
        if($result && $result->rowCount() > 0){
            $response = $result->fetch();
            $image = Yooz_Manager_Utils::get_file_by_id($response['message_image_id']);
            $response['image_url'] = $image && !empty($image['file_url']) ? $image['file_url'] : "/public/uploads/emptyImage.jpg";
            $response['conditions'] = $conditions = !empty($response['conditions']) && unserialize($response['conditions']) ? unserialize($response['conditions']) : [];

            if(is_array($conditions) && count($conditions) > 0){
                $response = array_merge($response , $response['conditions']);
//                if(!empty($conditions['has_cards']) && is_array($conditions['has_cards'])){
//                    $response['has_cards[]'] = array_combine($conditions['has_cards'], $conditions['has_cards']);
//                }
                if(!empty($conditions['has_missions']) && is_array($conditions['has_missions'])){
                    $response['has_missions[]'] = array_combine($conditions['has_missions'], $conditions['has_missions']);
                }
                if(!empty($conditions['has_gifts']) && is_array($conditions['has_gifts'])){
                    $response['has_gifts[]'] = array_combine($conditions['has_gifts'], $conditions['has_gifts']);
                }
                if(!empty($conditions['register_date_from'])){
                    $jdate = JDate::getDate(strtotime($conditions['register_date_from']));
                    $response["register_from[year]"] = $jdate['year'];
                    $response["register_from[month]"] = $jdate['mon'];
                    $response["register_from[day]"] = $jdate['mday'];
                }
                if(!empty($conditions['register_date_until'])){
                    $jdate = JDate::getDate(strtotime($conditions['register_date_until']));
                    $response["register_until[year]"] = $jdate['year'];
                    $response["register_until[month]"] = $jdate['mon'];
                    $response["register_until[day]"] = $jdate['mday'];
                }
            }

        }
        return $response;
    }

    public function get_messages(){
        $response = false;
        $result = $this->db->select($this->table_name , "*");
        if($result && $result->rowCount() > 0){
            $response = $result->fetchAll();
        }
        return $response;
    }
    public function get_messages_ui(){
        require_once __DIR__."/../Views/Admin/template-parts/message_settings/message_item.php";
        $items = $this->get_messages();
        $items = $items && is_array($items) ? $items : [];
        return get_interactive_messages($items);
    }

    public function delete_message_item(int $message_ID){
        $result = $this->db->delete($this->table_name , "message_ID='$message_ID'");
        return (bool)$result;
    }

    public function add_message($id , $title , $text, $gift_coins , $conditions , $image_id){
        $data = [
            'message_title'     => $title,
            'message_text'      => $text,
            'gift_coins'        => $gift_coins,
            'conditions'        => serialize($conditions),
            'message_image_id'  => $image_id,
        ];
        if($id == 0){
            $check = $this->db->select($this->table_name , "*" , "message_title='$title' AND message_text='$text'");
            if($check->rowCount() > 0){
                $this->set_error("این آیتم قبلا ایجاد شده است.");
                return false;
            }else{
                $result = $this->db->insert($this->table_name , $data);
                $data['message_ID'] = $this->db->lastInsertId();
            }
        }
        if($id > 0){
            $result = $this->db->update($this->table_name , $data , "message_ID='$id'");
            $data['message_ID'] = $id;
        }
        
        $data['conditions'] = $conditions;
        $this->check_user_interactive_messages($data);
        
        if(!empty($result)){return $result;}
        return false;
    }
    
    public function check_user_interactive_messages(array $message): void
    {
        $conditions = $message['conditions'];
        if(!empty($conditions) && is_array($conditions)){
            if(!empty($conditions['message_members'])){
                $message_members = $conditions['message_members'];
                
                if($message_members == "last_month_medalists"){
                    $users = $this->get_last_month_medalists();
                }elseif($message_members == "medalists"){
                    $users = $this->get_all_medalists();
                }else{
                    $users = $this->get_all_players();
                }
                
                
                if(!empty($users) && is_array($users) && count($users) > 0){
                    $table = $this->notification_table;
                    $stmt = $this->db->prepare("INSERT INTO $table 
                                                    (user_ID,message_ID,notification_title,notification_text,notification_image,notification_coins,notification_status,create_time)
                                             VALUES (:user_ID,:message_ID,:notification_title,:notification_text,:notification_image,:notification_coins,:notification_status,:create_time)");
                    if($stmt){
                        
                        $image = "";
                        if(!empty($message['message_image_id'])){
                            $file = Yooz_Manager_Utils::get_file_by_id(intval($message['message_image_id']));
                            if($file && is_array($file) && !empty($file['file_url'])){
                                $image = $file['file_url'];
                            }
                        }
                        
                        $data = [
                                    'message_ID'            => $message['message_ID'],
                                    'notification_title'    => $message['message_title'],
                                    'notification_text'     => $message['message_text'],
                                    'notification_image'    => $image,
                                    'notification_coins'    => $message['gift_coins'],
                                    'notification_status'   => "no_visited",
                                    'create_time'           => date("Y-m-d H:i:s"),
                                ];
                        
                        foreach($users as $user){
                            if($user && is_array($user) && !empty($user['user_register_date'])){
                                $user_ID = $user['user_ID'];
                                $access = true;    
                                if($message_members == "filtered"){
                                    if(!empty($conditions['min_coins']) && $conditions['min_coins'] > $user['coins_number']){$access = false;}
                                    if(!empty($conditions['max_coins']) && $conditions['max_coins'] < $user['coins_number']){$access = false;}
                                    if(!empty($conditions['register_date_from']) && strtotime($conditions['register_date_from']) > strtotime($user['user_register_date'])){
                                        $access = false;
                                    }
                                    if(!empty($conditions['register_date_until']) && strtotime($conditions['register_date_until']) < strtotime($user['user_register_date'])){
                                        $access = false;
                                    }
//                                    if(!empty($conditions['has_cards']) && is_array($conditions['has_cards'])){
//                                        foreach ($conditions['has_cards'] as $has_card){
//                                            if(empty($user['cards']) || !array_key_exists($has_card , $user['cards'])){
//                                                $access = false;
//                                                break;
//                                            }
//                                        }
//                                    }
                                    if(!empty($conditions['has_missions']) && is_array($conditions['has_missions'])){
                                        foreach ($conditions['has_missions'] as $has_missions){
                                            if(empty($user['missions']) || !array_key_exists($has_missions , $user['missions'])){
                                                $access = false;
                                                break;
                                            }
                                        }
                                    }
                                    if(!empty($conditions['has_gifts']) && is_array($conditions['has_gifts'])){
                                        foreach ($conditions['has_gifts'] as $has_gifts){
                                            if(empty($user['gifts']) || !array_key_exists($has_gifts , $user['gifts'])){
                                                $access = false;
                                                break;
                                            }
                                        }
                                    }
                                }
                                
        
                                if($access){
                                    if(!array_key_exists($message['message_ID'] , $user['notifications'])){
                                        $data['user_ID'] = $user_ID;
                                        $exec = $stmt->execute($data);
                                    }
                                }
                            }
                        }   
                    }
                }
            }
        }
    }
    
    public function get_all_players(): array
    {
        $usersModel = new UserModel();
        $users = $usersModel->get_players();
        return $users && is_array($users) ? $users : [];
    }

    public function get_all_medalists(): array
    {
        $usersModel = new UserModel();
        $gameModel = new Game_Model();
        $users = [];
        $query = "SELECT * FROM
                     $usersModel->users_table users
                  INNER JOIN
                     $gameModel->user_medals_table medals
                  ON users.user_ID=medals.user_ID";
        $result = $this->db->query($query);
        if($result && $result->rowCount() > 0){
            $records = $result->fetchAll();
            foreach($records as $record){
                $users[$record['user_ID']] = $gameModel->set_user_game_details($record , true);
            }
        }
        return $users;
    }

    public function get_last_month_medalists(): array
    {
        $currentJalali = JDate::date('Y-n-j');
        // Split the current Jalali date into year, month, and day
        list($year, $month, $day) = explode('-', $currentJalali);
        // Calculate the previous month
        if($month == 1){
            // If the current month is Farvardin (1), go back to Esfand (12) of the previous year
            $prevMonthYear = $year - 1;
            $prevMonthMonth = 12;
        }else{
            // Otherwise, just subtract one from the current month
            $prevMonthYear = $year;
            $prevMonthMonth = $month - 1;
        }
        $startOfPrevMonth = JDate::to_greg_date($prevMonthYear , $prevMonthMonth , 1 , 0 , 0 , 0);
        $endOfPrevMonth = JDate::to_greg_date($year , $month , 1 , 0 , 0 , 0);

        $usersModel = new UserModel();
        $gameModel = new Game_Model();
        $users = [];
        $query = "SELECT * FROM
                     $usersModel->users_table users
                  INNER JOIN
                     $gameModel->user_medals_table medals
                  ON users.user_ID=medals.user_ID
                  WHERE medals.medal_achieve_date < '$endOfPrevMonth' AND medals.medal_achieve_date > '$startOfPrevMonth'";
        $result = $this->db->query($query);
        if($result && $result->rowCount() > 0){
            $records = $result->fetchAll();
            foreach($records as $record){
                $users[$record['user_ID']] = $gameModel->set_user_game_details($record , true);
            }
        }
        return $users;
    }


}