<?php
namespace App\Models;
use Core\Avatars;
use Core\Model;
use Core\SMS;
use Core\Utils;
use Core\ErrorsTrait;
use Plugins\Yooz_Manager\Yooz_Manager_Utils;

class UserModel extends Model{
    use ErrorsTrait;
    public $users_table = "yooz_users";
    /* set cookie _YAIDU_ mean Yooz User Session Token */
    public $usermeta_table = "yooz_usermeta";
    private $cookie_name = '_YUST_';
    private $current_user;



    public function get_users(string $where_clause = "", string $limit = ""): bool|array{
        $stmt = $this->db->select($this->users_table , "*" , $where_clause , $limit);
        $users = [];
        $cities = $this->get_cities();
        if($stmt->rowCount() > 0){
            while($record = $stmt->fetch()){
                $after_set = $this->set_meta_to_user($record);
                $record = !empty($after_set) && is_array($after_set) ? $after_set : $record;
                if(!empty($record['city_ID']) && !empty($cities[$record['city_ID']])){
                    $cityInfo = $cities[$record['city_ID']];
                    $record['city'] = $cityInfo['city'];
                    $record['province'] = $cityInfo['province'];
                    $record['province_id'] = $cityInfo['province_id'];
                }
                $users[] = $record;
            }
            return $users;
        }
        return false;
    }
    public function get_cities(): array
    {
        $response = [];
        $result = $this->db->select("city");
        if($result && $result->rowCount() > 0){
            while($city = $result->fetch()){
                $response[$city['id']] = $city;
            }
        }
        return $response;
    }

    public function get_user(string $where_clause = ""){
        $users = $this->get_users($where_clause);
        if($users && is_array($users)){
            return array_shift($users);
        }
        return false;
    }

    public function get_players(string $where_clause = "", string $limit = ""): bool|array
    {
        $users = $this->get_users($where_clause , $limit);
        if(!empty($users) && is_array($users)){
            $gameModel = new Game_Model();
            $records = [];
            foreach ($users as $user){
                $user_ID = $user['user_ID'];
                $records[$user_ID] = $gameModel->set_user_game_details($user , true);
            }
            return $records;
        }
        return false;
    }
    public function get_player(string $where_clause = ""): bool|array
    {
        $user = $this->get_user($where_clause);
        if(!empty($user) && is_array($user) && !empty($user['user_ID'])){
            $gameModel = new Game_Model();
            return $gameModel->set_user_game_details($user , true);
        }
        return false;
    }

    public function users_count(string $where_clause = ""){
        $result = $this->db->select($this->users_table , "COUNT(*)" , $where_clause);
        if($result && $result->rowCount() > 0){
            return $result->fetch()['COUNT(*)'];
        }
        return 0;
    }

    public function get_users_coins(int|null $user_ID = null){
        $user_cond = !empty($user_ID) ? " AND user_ID='$user_ID'" : "";
        $result = $this->db->select($this->usermeta_table , "SUM(meta_value)" , "meta_key='coins_number'".$user_cond);
        if($result && $result->rowCount() > 0){
            return $result->fetch()['SUM(meta_value)'];
        }
        return 0;
    }
    public function is_login(){
        if(isset($_COOKIE[$this->cookie_name])){
            $cookieValue = Utils::test_input($_COOKIE[$this->cookie_name]);
            if(!empty($cookieValue)){
                $user = $this->get_user("session_token='$cookieValue'");
                if($user){
                    $this->current_user = $user;
                    return true;
                }
            }
        }
        return false;
    }

    public function get_current_user(){
        if($this->is_login()){
            $user = $this->current_user;
            return is_array($user) ? $user : false;
        }
        return false;
    }

    public function hash_password($password){
        return md5($password);
    }



    private function set_meta_to_user(array $user){
        $avatars = Avatars::$avatars;
        $userOptions = $this->get_user_meta($user['user_ID']);
        if(is_array($userOptions)){
            $user = array_merge($user , $userOptions);
        }
        $user["profile_image_file"] = !empty($user['profile_image']) && array_key_exists($user['profile_image'] , $avatars) ? $avatars[$user['profile_image']] : "";
        return $user;
    }
    private function get_user_meta(int $user_ID){
        $response = [];
        $stmt = $this->db->select($this->usermeta_table , "*" , "user_ID='$user_ID'");
        if($stmt->rowCount() > 0){
            $options = $stmt->fetchAll();
            if(is_array($options)){
                foreach ($options as $option){
                    $response[$option['meta_key']] = $option['meta_value'];
                }
            }
        }
        return $response;
    }


    /*
    * set cookie to check user information
    * the cookie value is encoded with bin2hex and base64_encode to prevent find information by anyone
    * $seprator is used to detect the id and username after decode the cookie value
    * */
    public function set_user_login($userID){
        $token = bin2hex(random_bytes(32)."*_".$userID."_*".random_bytes(32));
        $stmt = $this->db->update($this->users_table , ['session_token'=>$token] , "user_ID='$userID'");
        if($stmt){
            setcookie($this->cookie_name , $token , time() + 2592000 , "/");
            return true;
        }
        return false;
    }
    public function is_acceptable_password($password):bool{
        $pattern = "/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[@!#$%^&*])[A-Za-z\d@!#$%^&*]{6,18}$/";
        return (bool)preg_match($pattern, $password);
    }

    public function register_user($phone){
        $otp = $this->generate_otp($phone);
        $inviter_ID = 0;
        if(!empty($_COOKIE['inviter'])){
            $inviterCode = @base64_decode(@hex2bin($_COOKIE["inviter"]));
            if(!empty($inviterCode) && is_numeric($inviterCode)){
                $check = $this->db->select($this->users_table , "*" , "user_ID='$inviterCode'");
                if($check && $check->rowCount() > 0){
                    $inviter_ID = $inviterCode;
                }
            }
        }

        $sms = new SMS();
        $otpResult = $sms->send_auth_code($phone , $otp['code']);

        if($otpResult){
            $data = [
                'phone'         => $phone,
                'otp_code'      => $otp['code'],
                'otp_token'     => $otp['token'],
                'otp_expire'    => date("Y-m-d H:i:s" , $otp['expire']),
                'inviter_ID'    => $inviter_ID,
            ];
            $result = $this->db->insert($this->users_table , $data);
            if($result){
                return $otp['token'];
            }else{
                $this->set_error("ثبت نام ناموفق! دوباره تلاش کنید.");
            }
        }else{
            $this->set_error("رمز عبور ارسال نشد!");
        }
        return false;
    }

    public function generate_otp($phone): array
    {
        $code = rand(10000 , 99999);
        $token = bin2hex(random_bytes(24).$phone.random_bytes(24));
        $expire = time() + 300;
        return ['code'=> $code, 'token'=> $token, 'expire' => $expire];
    }

    public function authenticate_user($phone){
        $otp = $this->generate_otp($phone);
        $sms = new SMS();
        $otpResult = $sms->send_auth_code($phone , $otp['code']);
        if($otpResult){
            $data = [
                'otp_code'      => $otp['code'],
                'otp_token'     => $otp['token'],
                'otp_expire'    => date("Y-m-d H:i:s" , $otp['expire']),
            ];
            $result = $this->db->update($this->users_table , $data , "phone='$phone'");
            if($result){
                return $otp['token'];
            }else{
                $this->set_error("عملیات ناموفق! دوباره تلاش کنید.");
            }
        }else{
            $this->set_error("رمز عبور ارسال نشد!");
        }
        return false;
    }


    public function set_user_meta(string $meta_key , string $meta_value , int $user_ID = 0) : bool{
        if($user_ID === 0){
            $user = $this->get_current_user();
            $user_ID = $user['user_ID'];
        }
        $data = ['user_ID'=>$user_ID, 'meta_key' => $meta_key, 'meta_value' => $meta_value,];
        $check = $this->db->select($this->usermeta_table , "*" , "user_ID='$user_ID' AND meta_key='$meta_key'");
        if($check->rowCount() > 0){
            return $this->db->update($this->usermeta_table , $data , "user_ID='$user_ID' AND meta_key='$meta_key'");
        }else{
            return $this->db->insert($this->usermeta_table , $data);
        }
    }
    public function set_user_data(array $data, int $user_ID = 0){
        if($user_ID === 0){
            $user = $this->get_current_user();
            $user_ID = $user['user_ID'];
        }else{
            $user = $this->get_user("user_ID='$user_ID'");
        }

        if($user && is_array($user)){

            $userData = [
                'display_name'      => $data['display_name'] ?? $user['display_name'],
                'phone'             => $data['phone'] ?? $user['phone'],
                'otp_token'         => $data['otp_token'] ?? $user['otp_token'],
                'otp_code'          => $data['otp_code'] ?? $user['otp_code'],
                'otp_expire'        => $data['otp_expire'] ?? $user['otp_expire'],
                'session_token'     => $data['session_token'] ?? $user['session_token'],
                'user_register_date'=> $data['user_register_date'] ?? $user['user_register_date'],
                'inviter_ID'        => $data['inviter_ID'] ?? $user['inviter_ID'],
                'total_score'       => $data['total_score'] ?? $user['total_score'],
                'tour_guide'        => $data['tour_guide'] ?? $user['tour_guide'],
            ];

            $updateResult = $this->db->update($this->users_table , $userData , "user_ID='$user_ID'");
            if($updateResult){
                foreach ($data as $key => $val){
                    if(!array_key_exists($key , $userData)){
                        $metaResult = $this->set_user_meta($key , $val , $user_ID);
                        if(!$metaResult){
                            $this->set_error("برخی از اطلاعات ذخیره نشدند.");
                            break;
                        }
                    }
                }
                return true;
            }else{
                $this->set_error("ذخیره اطلاعات ناموفق! دوباره تلاش کنید.");
            }
        }else{
            $this->set_error("کاربر یافت نشد.");
        }
        return false;
    }

    public function get_user_ranking(int $user_ID , int $user_score){
        $userPosition = 1;
        $query = "SELECT COUNT(*) FROM $this->users_table
                  WHERE user_register_date IS NOT NULL AND total_score > '$user_score' OR (total_score='$user_score' AND user_ID < '$user_ID')
                  ORDER BY total_score DESC, user_ID ASC";
        $checkPosition = $this->db->query($query);
        if($checkPosition && $checkPosition->rowCount() > 0){
            $userPosition = intval($checkPosition->fetch()['COUNT(*)']) + 1;
        }

        $topUsers = $this->get_users("user_register_date IS NOT NULL ORDER BY total_score DESC , user_ID ASC" , "20");
        if($topUsers && is_array($topUsers)){
            $topPlayers = $topUsers;
        }else{
            $topPlayers = [];
        }

        return ["your_position" => $userPosition , "top_players" => $topPlayers];
    }
    
    public function logout_user(){
        setcookie($this->cookie_name , "" , time() - (86400 * 30) , "/");
    }
}