<?php
use Core\Utils;

function get_cards_template($cards, $user){
    $output = '';
    if(!empty($cards) && is_array($cards)){
        foreach($cards as $card_ID => $card){
            $hashID = bin2hex(base64_encode("card_".$card_ID));

            $rechargeTiming = 0;
            if($card['recharge_timing'] == "day"){
                $rechargeTiming = 60 * 60 * 24;
            }elseif($card['recharge_timing'] == "hour"){
                $rechargeTiming = 60 * 60;
            }
            $rechargeTime = $card['recharge_time'] * $rechargeTiming;

            $leftTime = 0;
            if(!empty($user['cards']) && is_array($user['cards']) && array_key_exists($card_ID , $user['cards'])){
                $userCard = $user['cards'][$card_ID];
                if(!empty($userCard) && is_array($userCard) && !empty($userCard['card_ID'])){
                    $leftTime = max(strtotime($userCard['card_claim_time']) + $rechargeTime - time() , 0);
                }
            }

            $card_bg_color = !empty($card['card_bg_color']) ? $card['card_bg_color'] : "#0097fe";
            $card_image_file = !empty($card['card_image_file']) ? $card['card_image_file'] : "";
            $card_name = !empty($card['card_name']) ? $card['card_name'] : "";
            $card_text = $card['card_text'];
            $card_coins = Utils::CoinsFormat($card['card_coins']);
            $card_title = !empty($card['card_title']) ? $card['card_title'] : $card['card_name'];
            $card_description = $card['card_description'];

            $output .= '
                <li class="game_card_item game_guide_item" data-i="'.$hashID.'" data-left-time="'.$leftTime.'">
                    <div class="game_card_ui" style="background-color:'.$card_bg_color.';">
                        <div class="game_card_inner">
                            <section class="game_card_image">
                                <img src="'.$card_image_file.'" alt="">
                            </section>
                            <section class="game_card_labels">
                                <h3 class="game_card_title">'.$card_name.'</h3>
                                <p class="game_card_description">'.$card_text.'</p>
                            </section>
                            <section class="game_card_coins">
                                <p class="card_coins_number">
                                    <i class="game_coin_ui parsi">'.$card_coins.'</i>
                                </p>
                            </section>
                        </div>
                        <div class="radial_countdown_timer">
                            <div class="circle_countdown_timer"></div>
                        </div>
                    </div>
    
                    <div class="game_guide_content hide">
                        <div class="popup_thumbnail">
                            <img src="'.$card_image_file.'">
                        </div>
                        <h6 class="popup_title">'.$card_title.'</h6>
                        <p class="popup_paragraph">
                            با دریافت این کارت،
                            <b class="coin_number">'.$card_coins.'</b>
                            سکه دریافت می‌کنید.
                        </p>
                        <p class="popup_paragraph">'.$card_description.'</p>
                        <div class="centerText yooz_json_form" data-page="game" data-action="card">
                            <input type="hidden" name="ci" value="'.$hashID.'">
                            <button class="card_get_coin_btn popup_button check_button accept_yooz_form_btn">دریافت سکه</button>
                        </div>
                    </div>
                </li>
            ';
        }
    }
    return $output;
}