<?php
use Core\License;
if(defined('YOOZ_ROOT')) {
    if(!empty($yooz_menu_items) && is_array($yooz_menu_items)) {
        function get_menu_items_template($menu){
            if(is_array($menu)){
                foreach ($menu as $item){
                    $nested_level = !empty($item['nested_level']) ? $item['nested_level'] : 1;
                    $values = $item['values'];
                    $menu_url = !empty($values['menu_url']) ? $values['menu_url'] : "#";
                    if($nested_level == 1){
                        if(!empty($item['childs']) && is_array($item['childs']) && count($item['childs']) > 0){
                            echo '<div class="yooz_sidebar_item yooz_sidebar_has_child_item">
                                    <section class="yooz_sidebar_item_ui" data-slug="'.$values['menu_slug'].'">
                                        <i class="fas fa-fw fa-'.$values['menu_icon'].' yooz_sidebar_icon"></i>
                                        <label>'.$values['menu_name'].'</label>
                                        <span class="fas fa-angle-down collapse_icon yooz_sidebar_icon"></span>
                                    </section>
                        
                                    <section class="yooz_sidebar_item_childs_container">';
                            get_menu_items_template($item['childs']);
                            echo '</section>
                                </div>';
                        }else{
                            echo '<a href="'.$menu_url.'">
                                        <div class="yooz_sidebar_item" data-slug="'.$values['menu_slug'].'">
                                            <section class="yooz_sidebar_item_ui">
                                                <i class="fas fa-fw fa-'.$values['menu_icon'].' yooz_sidebar_icon"></i>
                                                <label>'.$values['menu_name'].'</label>
                                            </section>
                                        </div>
                                    </a>';
                        }
                    }else{
                        echo '<a href="'.$menu_url.'">
                                    <li class="yooz_sidebar_item_child child_level_'.($nested_level - 1).'" data-slug="'.$values['menu_slug'].'">
                                        <label>'.$values['menu_name'].'</label>
                                    </li>
                                </a>';
                        if(!empty($item['childs']) && is_array($item['childs']) && count($item['childs']) > 0){
                            get_menu_items_template($item['childs']);
                        }
                    }
                }
            }
        }

        ?>
        <nav id="yooz_sidebar_panel" class="fixBlock whiteBg">
            <div id="yooz_sidebar_panel_logo">
                <a href="<?php echo License::url(); ?>">
                    <img src="<?php echo License::logo(); ?>" alt="<?php echo License::name(); ?>">
                </a>
            </div>
            <?php get_menu_items_template($yooz_menu_items); ?>
            <div id="yooz_sidebar_panel_subscription">
                <div id="yooz_panel_subscription_box">
                    <div class="subscription_status"><span><i class="fas fa-fw fa-shopping-cart"></i>وضعیت اشتراک: </span><span><?php echo \Core\Utils::PersianNumber(License::expire()); ?></span></div>
                    <div class="subscription_update"><i id="updateSubscriptionStatus" class="fas fa-fw fa-repeat" title="به روز رسانی وضعیت اشتراک"></i></div>
                </div>
            </div>
        </nav>
        <?php
    }
}
?>