<?php
function get_card_coins($coins){
    $coins = intval($coins);
    if($coins >= 1000000){
        $coins = round($coins / 1000000 , 1) . "M";
    }elseif($coins >= 1000){
        $coins = round($coins / 1000 , 1) . "K";
    }
    return $coins;
}
function get_game_cards(array $game_cards){
    $cardsItems = "";$cards_number = 0;
    foreach($game_cards as $card){
        if(!empty($card['card_ID'])){
            $cards_number++;
            $card_coins = get_card_coins($card['card_coins']);
            $image = \Plugins\Yooz_Manager\Yooz_Manager_Utils::get_file_by_id($card['card_image_id']);
            $cardImage = $image && !empty($image['file_url']) ? $image['file_url'] : "/public/uploads/emptyImage.jpg";
            $cardsItems .= '
                <li class="game_card_item game_part_item '.$card['display_status'].'_display_part_item" style="background-color:'.$card['card_bg_color'].';">
                    <div class="game_card_item_inner game_part_item_inner">
                        <section class="game_card_image">
                            <img src="'.$cardImage.'" alt="'.$card['card_name'].'">
                        </section>
                        <section class="game_card_labels">
                            <h3 class="game_card_title">'.$card['card_name'].'</h3>
                            <p class="game_card_description">'.$card['card_text'].'</p>
                        </section>
                        <section class="game_card_coins">
                            <div class="game_card_coin_ui">
                                <li class="fas fa-coin"></li>
                                <span class="game_card_coins_amount">'.$card_coins.'</span>
                            </div>
                        </section>
                    </div>
                    <div class="game_card_buttons game_part_buttons">
                        <div class="edit_or_add_card_btn game_part_button_edit game_part_button_item yooz_json_form" data-page="game_coins"  data-action="get_card_info">
                            <button id="editCardItemButton">ویرایش</button>
                            <input type="hidden" name="card_ID" value="'.$card['card_ID'].'">
                        </div>
                        <div class="delete_card_btn game_part_button_item delete_item_button yooz_json_form" data-page="game_coins"  data-action="delete_card">
                            <button id="deleteCardItemButton">حذف</button>
                            <input type="hidden" class="delete_item_input" name="card_ID" value="'.$card['card_ID'].'">
                        </div>
                    </div>
                </li>
            ';
        }
    }

    $structure = '<ul class="game_cards_list">'.$cardsItems.'</ul>';
    return ["cards_number" => $cards_number, "structure" => $structure];
}