<?php
if(defined('YOOZ_ROOT')) {
    require_once "card_item.php";
    $gameCards = get_game_cards($card_items);


    $card_form = [
        "inputs"  => array(
            'items' => array(
                array(
                    'type'  =>  'image',
                    'name'  =>  'card_image_id',
                    'label' =>  'تصویر کارت',
                ),
                array(
                    'name'  =>  'card_name',
                    'label' =>  'نام کارت',
                    'value' =>  "",
                    'autocomplete'  => 'off',
                    "require"       => 'true'
                ),
                array(
                    'name'  =>  'card_text',
                    'label' =>  'متن کارت',
                    'value' =>  "",
                    'autocomplete'  => 'off'
                ),
                array(
                    'name'  =>  'card_title',
                    'label' =>  'عنوان کارت',
                    'value' =>  "",
                    'autocomplete'  => 'off'
                ),
                array(
                    'type'  =>  'textarea',
                    'name'  =>  'card_description',
                    'label'  =>  'توضیحات کارت',
                    'placeholder' =>  'توضیح کوتاهی در مورد این کارت بنویسید.',
                ),
                array(
                    'type'  =>  'number',
                    'name'  =>  'card_coins',
                    'label' =>  'تعداد سکه',
                ),
                array(
                    'type'  =>  'number',
                    'name'  =>  'recharge_time',
                    'label' =>  'زمان شارژ مجدد',
                    'item_class'   => 'half_row'
                ),
                array(
                    'type'  =>  'select',
                    'name'  =>  'recharge_timing',
                    'label' =>  'نوع زمان شارژ مجدد',
                    'item_class'   => 'half_row',
                    'options'   => array(
                        'day'   => 'روز',
                        'hour'  => 'ساعت'
                    ),
                ),
                array(
                    'type'  =>  'color',
                    'name'  =>  'card_bg_color',
                    'label' =>  'رنگ پس زمینه کارت',
                    'value' => "#000000"
                ),
                array(
                    'type'  =>  'select',
                    'name'  =>  'display_status',
                    'label' =>  'وضعیت',
                    'options' => array(
                        'yes'   => "فعال",
                        'no'   => "غیر فعال",
                    ),
                ),
                array(
                    'type'  =>  'hidden',
                    'name'  =>  'card_ID',
                    'input_id'  =>  'card_id_hidden_input',
                ),
            )
        )
    ];



?>

    <h6 class="yooz_title">کارت‌های سکه</h6>

    <?php if($gameCards && $gameCards['cards_number'] == 0){ ?>
        <div class="empty_section_text_box">
            <strong>اولین کارت رو ایجاد کن</strong>
            <p>مدیر عزیز هنوز هیچ کارتی تعریف نشده. شما می‌تونید روی دکمه افزودن کارت جدید کلیک کنید و اولین کارت شانس بازی خودتون رو تعریف کنید.</p>
        </div>
    <?php }else{ ?>
        <div class="empty_section_text_box">
            <strong>ویرایش و یا افزودن کارت</strong>
            <p>مدیر عزیز شما می‌توانید با کلیک بر روی افزودن کارت ، یک کارت جدید ایجاد نمایید. همچنین با کلیک بر روی نمایش همه ، می‌توانید کارت هایی که پیش تر ایجاد نمودید را مشاهده نمایید.</p>
        </div>
    <?php } ?>


    <div class="yooz_json_form" data-page="game_coins" data-action="get_card_info">
        <button id="addNewCardButton" class="edit_or_add_card_btn">افزودن کارت جدید</button>
        <input type="hidden" name="card_ID" value="0">
    </div>


    <div>
        <div id="all_cards_container">
            <?php echo $gameCards['structure']; ?>
        </div>
        <div class="centerText">
            <span id="display_all_cards" class="pointer">نمایش همه کارت‌ها</span>
        </div>
    </div>

    <div id="yooz_cards_popup_form" class="yooz_popup_block">
        <div class="yooz_popup_header">
            <span class="yooz_popup_closer"></span>
            <p>افزودن/ویرایش</p>
        </div>
        <div class="yooz_popup_form_container">
            <?php
            echo $formClass->get_form($card_form , "game_coins" , "save_card" , "ذخیره کارت" , "submitCardDataButton" , "card_settings_form");
            ?>
        </div>
    </div>
<?php
}
?>