<?php
if(defined('YOOZ_ROOT')) {
    require_once "mission_item.php";
    $gameMissions = get_game_missions($mission_items);


    $mission_form = [
        "inputs"  => array(
            'items' => array(
                array(
                    'type'  =>  'image',
                    'name'  =>  'mission_image_id',
                    'label' =>  'تصویر ماموریت',
                ),
                array(
                    'name'  =>  'mission_title',
                    'label' =>  'عنوان ماموریت',
                    'value' =>  "",
                    'autocomplete'  => 'off',
                    "require"       => 'true'
                ),
                array(
                    'name'  =>  'mission_description',
                    'label' =>  'توضیحات ماموریت',
                    'value' =>  "",
                    'autocomplete'  => 'off'
                ),
                array(
                    'name'  =>  'mission_button_label',
                    'label' =>  'متن دکمه',
                    'value' =>  "",
                    'autocomplete'  => 'off'
                ),
                array(
                    'type'  =>  'url',
                    'name'  =>  'mission_button_link',
                    'label' =>  'لینک دکمه',
                    'value' =>  "",
                    'placeholder'   =>'https://example.com',
                    'autocomplete'  => 'off'
                ),
                array(
                    'type'  =>  'number',
                    'name'  =>  'mission_coins',
                    'label' =>  'تعداد سکه',
                ),
                array(
                    'type'  =>  'hidden',
                    'name'  =>  'mission_bg_color',
                    'label' =>  'رنگ پس زمینه ماموریت',
                    'value' => "#000000"
                ),
                array(
                    'type'  =>  'select',
                    'name'  =>  'display_status',
                    'label' =>  'وضعیت',
                    'options' => array(
                        'yes'   => "فعال",
                        'no'   => "غیر فعال",
                    ),
                ),
                array(
                    'type'  =>  'hidden',
                    'name'  =>  'mission_ID',
                    'input_id'  =>  'mission_id_hidden_input',
                ),
            )
        )
    ];



    ?>

    <h6 class="yooz_title">ماموریت‌های بازی</h6>

    <?php if($gameMissions && $gameMissions['missions_number'] == 0){ ?>
        <div class="empty_section_text_box">
            <strong>اولین مارموریت رو ایجاد کن</strong>
            <p>مدیر عزیز هنوز هیچ ماموریتی تعریف نشده. شما می‌تونید روی دکمه افزودن ماموریت جدید کلیک کنید و اولین ماموریت بازی خودتون رو تعریف کنید.</p>
        </div>
    <?php }else{ ?>
        <div class="empty_section_text_box">
            <strong>ویرایش و یا افزودن ماموریت</strong>
            <p>مدیر عزیز شما می‌توانید با کلیک بر روی افزودن ماموریت جدید ، یک ماموریت جدید ایجاد نمایید. همچنین با کلیک بر روی نمایش همه ، می‌توانید ماموریت هایی که پیش تر ایجاد نمودید را مشاهده نمایید.</p>
        </div>
    <?php } ?>


    <div class="yooz_json_form" data-page="game_coins" data-action="get_mission_info">
        <button id="addNewMissionButton" class="edit_or_add_mission_btn">افزودن ماموریت جدید</button>
        <input type="hidden" name="mission_ID" value="0">
    </div>


    <div>
        <div id="all_missions_container">
            <?php echo $gameMissions['structure']; ?>
        </div>
        <div class="centerText">
            <span id="display_all_missions" class="pointer">نمایش همه ماموریت‌ها</span>
        </div>
    </div>

    <div id="yooz_missions_popup_form" class="yooz_popup_block">
        <div class="yooz_popup_header">
            <span class="yooz_popup_closer"></span>
            <p>افزودن/ویرایش</p>
        </div>
        <div class="yooz_popup_form_container">
            <?php
            echo $formClass->get_form($mission_form , "game_coins" , "save_mission" , "ذخیره ماموریت" , "submitMissionDataButton" , "mission_settings_form");
            ?>
        </div>
    </div>
    <?php
}
?>