<?php
if(defined('YOOZ_ROOT')) {
    require_once "guess_item.php";
    $guessItems = get_guess_items($guess_items);


    $guess_form = [
        "inputs"  => array(
            'items' => array(
                array(
                    'type'  =>  'image',
                    'name'  =>  'guess_image_id',
                    'label' =>  'عکس توضیحات کد شانس',
                ),
                array(
                    'name'  =>  'guess_code',
                    'label' =>  'کد شانس',
                    'value' =>  "",
                    'autocomplete'  => 'off',
                    "require"       => 'true'
                ),
                array(
                    'name'  =>  'guess_description',
                    'label' =>  'توضیحات کد شانس',
                    'value' =>  "",
                    'autocomplete'  => 'off'
                ),
                array(
                    'type'  =>  'number',
                    'name'  =>  'gift_coins',
                    'label' =>  'تعداد سکه جایزه',
                ),
                array(
                    'type'  =>  'number',
                    'name'  =>  'fine_coins',
                    'label' =>  'تعداد سکه جریمه',
                ),
                array(
                    'type'  =>  'date',
                    'name'  =>  'expiration_date',
                    'label' =>  'تاریخ انقضا',
                ),
                array(
                    'type'  =>  'select',
                    'name'  =>  'display_status',
                    'label' =>  'وضعیت',
                    'options' => array(
                        'yes'   => "فعال",
                        'no'   => "غیر فعال",
                    ),
                ),
                array(
                    'type'  =>  'hidden',
                    'name'  =>  'guess_ID',
                    'input_id'  =>  'guess_id_hidden_input',
                ),
            )
        )
    ];



    ?>

    <h6 class="yooz_title">کد‌های شانس</h6>

    <?php if($guessItems && $guessItems['items_number'] == 0){ ?>
        <div class="empty_section_text_box">
            <strong>اولین کد شانس رو ایجاد کن</strong>
            <p>مدیر عزیز هنوز هیچ کد شانسی تعریف نشده. شما می‌تونید روی دکمه افزودن کد جدید کلیک کنید و اولین کد شانس بازی خودتون رو تعریف کنید.</p>
        </div>
    <?php }else{ ?>
        <div class="empty_section_text_box">
            <strong>ویرایش و یا افزودن کد شانس</strong>
            <p>مدیر عزیز شما می‌توانید با کلیک بر روی افزودن کد شانس جدید ، یک کد شانس جدید ایجاد نمایید. همچنین با کلیک بر روی نمایش همه ، می‌توانید کد شانس هایی که پیش تر ایجاد نمودید را مشاهده نمایید.</p>
        </div>
    <?php } ?>


    <div class="yooz_json_form" data-page="game_coins" data-action="get_guess_info">
        <button id="addNewGuessButton" class="edit_or_add_guess_btn">افزودن کد جدید</button>
        <input type="hidden" name="guess_ID" value="0">
    </div>


    <div>
        <div id="all_guesses_container">
            <?php echo $guessItems['structure']; ?>
        </div>
        <div class="centerText">
            <span id="display_all_guess" class="pointer">نمایش همه کد‌های شانس</span>
        </div>
    </div>

    <div id="yooz_guess_popup_form" class="yooz_popup_block">
        <div class="yooz_popup_header">
            <span class="yooz_popup_closer"></span>
            <p>افزودن/ویرایش</p>
        </div>
        <div class="yooz_popup_form_container">
            <?php
            echo $formClass->get_form($guess_form , "game_coins" , "save_guess" , "ذخیره کارت" , "submitGuessDataButton" , "guess_settings_form");
            ?>
        </div>
    </div>
    <?php
}
?>