<?php
if(!function_exists("convert_large_numbers")){
    function convert_large_numbers($coins){
        $coins = intval($coins);
        if($coins >= 1000000){
            $coins = round($coins / 1000000 , 1) . "M";
        }elseif($coins >= 1000){
            $coins = round($coins / 1000 , 1) . "K";
        }
        return $coins;
    }
}
function get_event_items(array $items){
    $html = "";$items_number = 0;
    foreach($items as $item){
        if(!empty($item['event_ID'])){
            $items_number++;
            $item_coins = convert_large_numbers($item['required_coins']);
            $image = \Plugins\Yooz_Manager\Yooz_Manager_Utils::get_file_by_id($item['event_image_id']);
            $itemImage = $image && !empty($image['file_url']) ? $image['file_url'] : "/public/uploads/emptyImage.jpg";
            $html .= '
                <li class="game_mission_item game_part_item '.$item['event_status'].'_display_part_item">
                    <div class="game_mission_item_inner game_part_item_inner">
                        <section class="game_mission_image">
                            <div class="game_mission_image_box">
                                <img src="'.$itemImage.'" alt="'.$item['event_name'].'">
                            </div>   
                        </section>
                        <section class="game_mission_info">
                            <h3 class="game_mission_title">'.$item['event_name'].'</h3>
                            <p class="game_mission_description">'.$item['event_description'].'</p>
                            <div class="mission_button_adn_price_holder">
                                <section class="game_mission_coin_ui">
                                    <li class="fas fa-coin"></li>
                                    <span class="game_mission_coins_amount">'.$item_coins.'</span>
                                </section>
                            </div>
                        </section>
                    </div>
                    <div class="game_mission_buttons game_part_buttons">
                        <div class="edit_or_add_mission_btn game_part_button_edit game_part_button_item yooz_json_form" data-page="game_gifts"  data-action="get_event_info">
                            <button class="edit_or_add_event_btn">ویرایش</button>
                            <input type="hidden" name="event_ID" value="'.$item['event_ID'].'">
                        </div>
                        <div class="delete_mission_btn game_part_button_item delete_item_button yooz_json_form" data-page="game_gifts"  data-action="delete_event">
                            <button id="deletemissionItemButton">حذف</button>
                            <input type="hidden" class="delete_item_input" name="event_ID" value="'.$item['event_ID'].'">
                        </div>
                    </div>
                </li>
            ';
        }
    }

    $structure = '<ul class="game_event_list">'.$html.'</ul>';
    return ["items_number" => $items_number, "structure" => $structure];
}