<?php
if(!function_exists("convert_large_numbers")){
    function convert_large_numbers($coins){
        $coins = intval($coins);
        if($coins >= 1000000){
            $coins = round($coins / 1000000 , 1) . "M";
        }elseif($coins >= 1000){
            $coins = round($coins / 1000 , 1) . "K";
        }
        return $coins;
    }
}
function get_gift_cards(array $items){
    $html = "";$items_number = 0;
    foreach($items as $item){
        if(!empty($item['gift_ID'])){
            $items_number++;
            $card_coins = convert_large_numbers($item['required_coins']);
            $image = \Plugins\Yooz_Manager\Yooz_Manager_Utils::get_file_by_id($item['gift_image_id']);
            $itemImage = $image && !empty($image['file_url']) ? $image['file_url'] : "/public/uploads/emptyImage.jpg";
            $html .= '
                <li class="game_card_item game_part_item '.$item['gift_status'].'_display_part_item">
                    <div class="game_card_item_inner game_part_item_inner">
                        <section class="game_card_image">
                            <img src="'.$itemImage.'" alt="'.$item['gift_name'].'">
                        </section>
                        <section class="game_card_labels">
                            <h3 class="game_card_title">'.$item['gift_name'].'</h3>
                        </section>
                        <section class="game_card_coins">
                            <div class="game_card_coin_ui">
                                <li class="fas fa-coin"></li>
                                <span class="game_card_coins_amount">'.$card_coins.'</span>
                            </div>
                        </section>
                    </div>
                    <div class="game_card_buttons game_part_buttons">
                        <div class="edit_or_add_card_btn game_part_button_edit game_part_button_item yooz_json_form" data-page="game_gifts"  data-action="get_gift_info">
                            <button id="editCardItemButton">ویرایش</button>
                            <input type="hidden" name="gift_ID" value="'.$item['gift_ID'].'">
                        </div>
                        <div class="delete_card_btn game_part_button_item delete_item_button yooz_json_form" data-page="game_gifts"  data-action="delete_gift">
                            <button id="deleteCardItemButton">حذف</button>
                            <input type="hidden" class="delete_item_input" name="gift_ID" value="'.$item['gift_ID'].'">
                        </div>
                    </div>
                </li>
            ';
        }
    }

    $structure = '<ul class="game_cards_list">'.$html.'</ul>';
    return ["items_number" => $items_number, "structure" => $structure];
}