<?php
use \Plugins\Yooz_Manager\Yooz_Manager_Utils;
if(defined('YOOZ_ROOT')) {

    $medal_cond_image_file = $medal_win_image_file = "/public/uploads/emptyImage.jpg";
    if(!empty($medal_rules['medal_cond_image'])){
        $file = Yooz_Manager_Utils::get_file_by_id(intval($medal_rules['medal_cond_image']));
        if(!empty($file) && is_array($file) && !empty($file['file_url'])){
            $medal_cond_image_file = $file['file_url'];
        }
    }
    if(!empty($medal_rules['medal_win_image'])){
        $file = Yooz_Manager_Utils::get_file_by_id(intval($medal_rules['medal_win_image']));
        if(!empty($file) && is_array($file) && !empty($file['file_url'])){
            $medal_win_image_file = $file['file_url'];
        }
    }


    $medals_form = [
        "inputs"  => array(
            'items' => array(
                array(
                    'type'  =>  'select',
                    'name'  =>  'medals_activation',
                    'label' =>  'فعال بودن مدال‌ها',
                    'options' =>  array(
                        'yes'   => 'بله',
                        'no'    => 'خیر',
                    ),
                    'value' =>  !empty($medal_rules['medals_activation']) ? $medal_rules['medals_activation'] : "",
                ),
                array(
                    'type'  =>  'number',
                    'name'  =>  'get_medal_needed_coins',
                    'label' =>  'تعداد سکه مورد نیاز برای هر مدال',
                    'value' =>  !empty($medal_rules['get_medal_needed_coins']) ? intval($medal_rules['get_medal_needed_coins']) : 0,
                ),
            )
        ),
        "medals_cond"  => array(
            'title' => 'متن و آیکون شرایط کسب مدال',
            'items' =>  array(
                array(
                    'type'  =>  'image',
                    'name'  =>  'medal_cond_image',
                    'label' =>  'آیکون مدال',
                    'value' =>  $medal_cond_image_file,
                    'file_id'   => !empty($medal_rules['medal_cond_image']) ? intval($medal_rules['medal_cond_image']) : 0,
                ),
                array(
                    'type'  =>  'textarea',
                    'name'  =>  'medal_cond_descriptions',
                    'label'  =>  'متن توضیحات',
                    'placeholder' =>  'توضیح کوتاهی در مورد شرایط دریافت مدال بنویسید.',
                    'value' =>  !empty($medal_rules['medal_cond_descriptions']) ? $medal_rules['medal_cond_descriptions'] : "",
                ),
            )
        ),
        "medals_win"  => array(
            'title' => 'متن و آیکون برنده شدن هر مدال',
            'items' =>  array(
                array(
                    'type'  =>  'image',
                    'name'  =>  'medal_win_image',
                    'label' =>  'آیکون برنده شدن',
                    'value' =>  $medal_win_image_file,
                    'file_id'   => !empty($medal_rules['medal_win_image']) ? intval($medal_rules['medal_win_image']) : 0,
                ),
                array(
                    'type'  =>  'textarea',
                    'name'  =>  'medal_win_descriptions',
                    'label'  =>  'پیام برنده شدن',
                    'placeholder' =>  'متن پیام برنده شدن هر مدال را بنویسید.',
                    'value' =>  !empty($medal_rules['medal_win_descriptions']) ? $medal_rules['medal_win_descriptions'] : "",
                ),
            )
        ),
    ];

    echo '<h6 class="yooz_title">قوانین مدال‌ها</h6>';
    echo $formClass->get_form($medals_form , "game_rules" , "medal_rules" , "ذخیره تنظیمات" , "submitStoreInfo" , "store_settings_form");
}