<?php
if(defined("YOOZ_ROOT")){

    $profile_gift = 0;
    $rules = \Core\Site_Options::get("_yooz_main_game_rules");
    if($rules && is_array(unserialize($rules))){
        $rules = unserialize($rules);
        if(!empty($rules['profile_gift'])){
            $profile_gift = intval($rules['profile_gift']);
        }
    }

    $form = array(
        "inputs"=> array(
            "class" => "two_col_form",
            "items" => [
                array(
                    "name"          => "display_name",
                    "label"         => "نام یا لقب شما در بازی",
                    'value'         => !empty($user['display_name']) ? $user['display_name'] : "",
                    'item_class'    => "full_input",
                    //"required"      => true,
                ),
                array(
                    "name"          => "name",
                    "label"         => "نام",
                    'value'         => !empty($user['name']) ? $user['name'] : "",
                    'item_class'    => "full_input",
                    //"required"      => true,
                ),
                array(
                    "name"          => "family",
                    "label"         => "نام خانوادگی",
                    'value'         => !empty($user['family']) ? $user['family'] : "",
                    'item_class'    => "full_input",
                    //"required"      => true,
                ),
                array(
                    'type'          => 'gender',
                    "name"          => "gender",
                    "label"         => "جنسیت",
                    'value'         => !empty($user['gender']) ? $user['gender'] : "",
                    'item_class'    => "full_input",
                    //"required"      => true,
                ),
                array(
                    'type'          => 'date',
                    "name"          => "birthdate",
                    "label"         => "تاریخ تولد (پس از ذخیره، قابل تغییر نیست)",
                    'value'         => !empty($user['birthdate']) ? $user['birthdate'] : "",
                    //"required"      => true,
                    'item_class'    => "full_input",
                    'readonly'      => !empty($user['birthdate']),
                ),
                array(
                    'type'          => 'select',
                    "name"          => "province",
                    "label"         => "استان",
                    'options'       => $provinces,
                    'value'         => !empty($user['province_id']) ? $user['province_id'] : 0,
                    //"required"      => true,
                ),
                array(
                    'type'          => 'select',
                    "name"          => "city_ID",
                    "label"         => "شهر",
                    'options'       => !empty($cities) && is_array($cities) ? $cities : ["0"=> "استان را انتخاب کنید"],
                    'value'         => !empty($user['city_ID']) ? $user['city_ID'] : 0,
                    //"required"      => true,
                ),
            ]
        ),
    );
?>

    <section id="edit_profile_section">
        <span id="edit_profile_closer"></span>
        <div id="logout_game_container" class="yooz_json_form" data-page="game" data-action="logout">
            <button id="logout_game_button">خروج</button>
        </div>
        
        <div id="edit_profile_info">
            <h3>تکمیل پروفایل</h3>
            <p>برای دریافت <?php echo \Core\Utils::PersianNumber($profile_gift);  ?> سکه هدیه همین حالا</p>
            <p>پروفایل خود را تکمیل کنید</p>
        </div>
        <div id="edit_profile_form">
            <?php
            $regDate = !empty($user['user_register_date']) ? \Core\JDate::date("Y/m/d" , strtotime($user['user_register_date'])) : "";
            $regDate = \Core\Utils::PersianNumber($regDate);
            $phoneNumberHtml = '<p id="user_profile_phone">'.(!empty($user['phone']) ? \Core\Utils::PersianNumber($user['phone']) : "").'</p>';
            $thisYearMedalsHtml = '<p id="profile_this_year_medals">تعداد مدال‌های امسال: <span>'.\Core\Utils::PersianNumber($user['this_year_medals_number']).'</span></p>';
            $userimage = !empty($user['profile_image']) ? $user['profile_image'] : 0;
            $avatarsUi = \Core\Avatars::get_avatars_ui($userimage);
            $avatarsUi .= $phoneNumberHtml;
            $avatarsUi .= '<p id="profile_this_year_medals">'.$regDate.'<p>';
            $avatarsUi .= $thisYearMedalsHtml;
            $class = new \Core\User_Forms();
            echo $class->get_form($form , "game" , "edit_profile" , "ذخیره", "submitProfileForm" , "" , "" , "" , $avatarsUi);
            ?>
        </div>
        <div id="refresh_all_data_container" class="yooz_json_form" data-page="game" data-action="get_data"><button id="refresh_all_data" style="display:none;"></button></div>
    </section>

<?php
}
?>
