<?php
use Core\Utils;

function replaceAnchors($text){
    // Regular expression to match text within double asterisks
    return preg_replace_callback(
        '/\*\*(.*?)\*\*/',
        function($matches) {
            // Split the matched text by asterisk
            $parts = explode('*', $matches[1], 2); // Limit to 2 parts
            // Check if we have exactly 2 parts (link and text)
            if(count($parts) > 1) {
                $link = trim($parts[0]); // The first part is the link
                $linkText = !empty($parts[1]) ? trim($parts[1]) : $link; // The second part is the display text
                // Create an anchor tag
                return '<a href="' . htmlspecialchars($link) . '" target="_blank">' . htmlspecialchars($linkText) . '</a>';
            }
            return $matches[0]; // Return original if not a valid format
        },
        $text
    );
}

if(defined("YOOZ_ROOT")){
?>

    <div class="game_3d_icon">
        <img src="/public/uploads/message_icon.png" alt="message icon">
    </div>
    <h2 class="yooz_title centerText">پیامی برای شما</h2>
    <p class="centerText" style="font-size:1.17em;margin-bottom:20px;">اگه میخوای همیشه از اتفاقات مهم جا نمونی حتما پیام ها رو چک کن</p>

    <ul id="notifications">
        <?php
            if(!empty($user['notifications']) && is_array($user['notifications'])){
                foreach ($user['notifications'] as $notif){
                    $hashID = bin2hex(base64_encode("notif_".$notif['notification_ID']));
                    $claimClass = $notif['notification_status'] == "visited" ? "isClaimed" : "";
                    $create_time = !empty($notif['create_time']) ? \Core\JDate::date("Y/m/d" , strtotime($notif['create_time'])) : "";
                    $notifText = replaceAnchors($notif['notification_text']);
        ?>
            <li class="game_notif_item game_guide_item <?php echo $claimClass; ?>" data-i="<?php echo $hashID; ?>">
                <div class="notif_item_ui game_box flexBoxWithWrap">
                    <section class="notif_item_date_info flexBox">
                        <div class="col-2">
                            <i class="fa-regular fa-envelope"></i>
                        </div>
                        <div class="col-2 leftText">
                            <p class="notif_item_date"><?php echo Utils::PersianNumber($create_time); ?></p>
                        </div>
                    </section>
                    <section class="notif_item_info">
                        <h3 class="notif_item_title"><?php echo $notif['notification_title']; ?></h3>
                        <?php if(!empty($notif['notification_coins'])){ ?>
                        <p class="notif_coins_number">
                            <i class="game_coin_ui parsi">
                                <?php echo Utils::CoinsFormat($notif['notification_coins']); ?>
                            </i>
                        </p>
                        <?php } ?>
                    </section>
                    <section class="notif_open_button_holder">
                        <i class="fa-solid fa-angle-left"></i>
                    </section>
                </div>

                <div class="game_guide_content hide">
                    <?php if(!empty($notif['notification_image'])){ ?>
                    <div class="popup_thumbnail">
                        <img src="<?php echo $notif['notification_image']; ?>" alt="">
                    </div>
                    <?php } ?>
                    <h6 class="popup_title"><?php echo $notif['notification_title']; ?></h6>
                    <p class="popup_paragraph"><?php echo $notifText; ?></p>
                    <div class="centerText yooz_json_form" data-page="game" data-action="notification">
                        <input type="hidden" name="ni" value="<?php echo $hashID; ?>">
                        <button class="notif_job_btn popup_button check_button accept_yooz_form_btn">متوجه شدم</button>
                    </div>
                </div>
            </li>
        <?php
                }
            }
        ?>
    </ul>

<?php
}
?>