<?php
use Core\Utils;
if(defined("YOOZ_ROOT") && !empty($events) && is_array($events)){
?>
    <ul id="events">
        <?php
        foreach ($events as $event_ID => $event){
            $hashID = bin2hex(base64_encode("event_".$event_ID));
            $diff_time = max(strtotime($event['event_expire']) - time(),0);

            $claimedClass = !empty($user['events']) && is_array($user['events']) && array_key_exists($event_ID, $user['events']) ? "isClaimed" : "";
            $activeClass = !empty($user['coins_number']) && $user['coins_number'] >= $event['required_coins'] ? "" : "lowMoney";
        ?>
        <li class="event_item game_box <?php echo $activeClass." ".$claimedClass; ?>" data-i="<?php echo $hashID; ?>" data-price="<?php echo $event['required_coins']; ?>">
            <i class="claimed_check_icon fa-solid fa-check"></i>
            <div class="game_event_ui_inner">
                <div class="flexBox">
                    <section class="event_info">
                        <h2 class="event_headline"><?php echo $event['event_title']; ?></h2>
                        <h3 class="event_title"><?php echo $event['event_name']; ?></h3>
                        <?php if(empty($claimedClass)){ ?>
                            <p class="event_expire">
                                <strong class="countdown_timer" data-timestamp="<?php echo $diff_time; ?>"></strong>
                                <span>زمان باقی مانده</span>
                            </p>
                        <?php } ?>
                    </section>
                    <section class="event_image_and_coins">
                        <div class="event_image">
                            <img src="<?php echo $event['event_image']; ?>" alt="<?php echo $event['event_name']; ?>">
                        </div>
                    </section>
                </div>
                <div class="yooz_json_form" style="margin-top:20px;" data-page="game" data-action="event">
                    <input type="hidden" name="ei" value="<?php echo $hashID; ?>">
                    <button class="get_event_card check_button accept_yooz_form_btn"><?php echo Utils::CoinsFormat($event['required_coins']); ?> سکه مورد نیاز</button>
                </div>
            </div>

            <div class="event_success_popup_message_content message_box_content_container">
                <div class="popup_thumbnail">
                    <img src="<?php echo $event['event_image']; ?>" alt="">
                </div>
                <h6 class="popup_title"><?php echo $event['event_name']; ?></h6>
                <p class="popup_paragraph"><?php echo $event['event_description']; ?></p>
                <div class="centerText">
                    <button class="popup_button check_button message_popup_close_button" data-next="">متوجه شدم</button>
                </div>
            </div>

        </li>
        <?php
        }
        ?>
    </ul>
<?php
}
?>