<?php
use Core\Utils;
if(defined("YOOZ_ROOT") && !empty($medal_setting) && is_array($medal_setting)){
    $medal = $medal_setting;
    if(!empty($medal['medals_activation']) && $medal['medals_activation'] == "yes"){

    $medalImage = "/public/uploads/default_medal_image.png";

    $getMedalNeededCoins = !empty($medal['get_medal_needed_coins']) ? $medal['get_medal_needed_coins'] : 0;

    $currentMedalProgress = 0;
    if(!empty($user['positive_coins_number'])){
        $currentMedalProgress = round($user['positive_coins_number'] / $getMedalNeededCoins * 100 , 2);
        $currentMedalProgress = $currentMedalProgress >= 100 ? 100 : ($currentMedalProgress <= 0 ? 0 : $currentMedalProgress);
        
    }
    $userMedals = $user['medals_number'];
?>
    <section id="medal_section" class="flexBox"
             data-medal-coins="<?php echo $getMedalNeededCoins; ?>"
             data-medal-number="<?php echo $userMedals; ?>">
        <section id="medal_icon_section">
            <div id="medal_icon_holder">
                <img src="<?php echo $medalImage; ?>" alt="مدال">
            </div>
            <p id="user_medal_number"><?php echo Utils::PersianNumber($userMedals); ?></p>
        </section>
        <section id="medal_info_section">
            <section class="flexBox">
                <div id="medal_descriptions">
                    <h2 id="medal_title">هر <?php echo Utils::PersianNumber($getMedalNeededCoins); ?> سکه یک مدال طلا</h2>
                </div>
                <div id="medal_buttons">
                    <div class="game_guide_item">
                        <button id="medal_guide_btn" class="game_box_bg">راهنمای مدال</button>
                        <div class="game_guide_content hide">
                            <div class="popup_thumbnail">
                                <img src="<?php echo !empty($medal['medal_cond_image_file']) ? $medal['medal_cond_image_file'] : ""; ?>" alt="">
                            </div>
                            <p class="popup_paragraph">
                                <?php echo !empty($medal['medal_cond_descriptions']) ? $medal['medal_cond_descriptions'] : ""; ?>
                            </p>
                            <div class="centerText">
                                <button class="popup_button check_button popup_close_button">متوجه شدم</button>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section id="medal_progress_ui">
                <div id="medal_progressbar" class="game_box">
                    <span style="width:<?php echo $currentMedalProgress; ?>%;"></span>
                </div>
            </section>
        </section>

        <div id="win_medal_message_box" class="message_box_content_container">
            <?php if(!empty($medal['medal_win_image'])){ ?>
            <div class="popup_thumbnail">
                <img src="<?php echo $medal['medal_win_image_file']; ?>" alt="">
            </div>
            <?php } ?>
            <p class="popup_paragraph">
                <?php echo !empty($medal['medal_win_descriptions']) ? $medal['medal_win_descriptions'] : ""; ?>
            </p>
            <div class="centerText">
                <button class="popup_button check_button message_popup_close_button" data-next="">متوجه شدم</button>
            </div>
        </div>

    </section>

<?php
    }
}
?>
