<?php
use Core\Utils;
if(defined("YOOZ_ROOT") && !empty($missions) && is_array($missions)){
?>
    <ul id="game_missions">
        <?php
        foreach ($missions as $mission_ID => $mission){
            $hashID = bin2hex(base64_encode("mission_".$mission_ID));
            $claimClass = !empty($user['missions']) && is_array($user['missions']) && array_key_exists($mission_ID , $user['missions']) ? "isClaimed" : "";

            $buttonText = empty($claimClass) ? $mission['mission_button_label'] : "انجام شد";
            $buttonClass = empty($claimClass) ? 'accept_yooz_form_btn' : "";
        ?>
            <li class="game_mission_item game_guide_item <?php echo $claimClass; ?>" data-i="<?php echo $hashID; ?>">
                <div class="mission_item_ui game_box flexBox">
                    <div class="mission_thumbnail_box">
                        <img src="<?php echo !empty($mission['mission_image_file']) ? $mission['mission_image_file'] : ""; ?>" alt="">
                    </div>
                    <section class="mission_item_info">
                        <h3 class="mission_item_title"><?php echo $mission['mission_title']; ?></h3>
                        <p class="mission_coins_number">
                            <i class="game_coin_ui parsi"><?php echo Utils::CoinsFormat($mission['mission_coins']); ?></i>
                        </p>
                    </section>
                    <section class="mission_open_button_holder">
                        <i class="fa-solid fa-angle-left"></i>
                    </section>
                </div>

                <div class="game_guide_content hide">
                    <div class="popup_thumbnail">
                        <img src="<?php echo !empty($mission['mission_image_file']) ? $mission['mission_image_file'] : ""; ?>" alt="">
                    </div>
                    <h6 class="popup_title"><?php echo $mission['mission_title']; ?></h6>
                    <p class="popup_paragraph"><?php echo $mission['mission_description']; ?></p>
                    <?php if(!empty($mission['mission_button_link'])){} ?>
                    <div class="centerText yooz_json_form" data-page="game" data-action="mission">
                        <input type="hidden" name="mi" value="<?php echo $hashID; ?>">
                        <button class="mission_job_btn popup_button check_button <?php echo $buttonClass; ?>">
                            <?php echo $buttonText; ?>
                        </button>
                    </div>
                </div>
            </li>
        <?php
        }
        ?>
    </ul>
<?php
}
?>
