<?php
if(defined("YOOZ_ROOT") && !empty($user) && !empty($user['user_ID'])){
    $userModel = new \App\Models\UserModel();
    $userRank = $userModel->get_user_ranking($user['user_ID'] , $user['total_score']);

    $rankingGuide = "";
    $rankingData = \Core\Site_Options::get("_app_score_system");
    if(!empty($rankingData) && is_array(unserialize($rankingData))){
        $rankingData = unserialize($rankingData);
        $rankingGuide = !empty($rankingData['descriptions']) ? $rankingData['descriptions'] : "";
    }
?>
    <section id="top_rank_users">
        <span class="top_rank_closer"></span>

        <div class="flexBox">
            <div class="col-2">
                <p id="your_rank">
                    <label>رتبه شما :</label>
                    <span><?php echo \Core\Utils::PersianNumber($userRank['your_position']); ?></span>
                </p>
            </div>
            <div class="col-2 ltr leftText game_guide_item">
                <button id="ranking_guide_button"  class="game_box_bg">راهنمای رتبه بندی</button>
                <div class="game_guide_content hide">
                    <p class="popup_title">نحوه رتبه بندی</p>
                    <p class="popup_paragraph"><?php echo $rankingGuide; ?></p>
                    <div class="centerText">
                        <button class="popup_button check_button popup_close_button">متوجه شدم</button>
                    </div>
                </div>
            </div>
        </div>

        <div class="game_3d_icon">
            <img src="/public/uploads/top_rank.png" alt="golden cup">
        </div>
        <h2 class="yooz_title">رتبه بندی کاربران</h2>

        <ul id="top_players">
            <?php
                if(!empty($userRank['top_players']) && is_array($userRank['top_players'])){
                    $rank = 0;
                    foreach ($userRank['top_players'] as $player){
                        $rank++;
                        $image = !empty($player['profile_image_file']) ? $player['profile_image_file'] : "/public/uploads/emptyUser.jpg";
            ?>
                <li class="top_player_item flexBox game_box">
                    <section class="top_player_image">
                        <img src="<?php echo $image; ?>" alt="">
                    </section>
                    <section class="top_player_info">
                        <p class="top_player_name"><?php echo !empty($player['display_name']) ? $player['display_name'] : "کاربر"; ?></p>
                        <p class="top_player_score">
                            <?php echo !empty($player['total_score']) ? \Core\Utils::PersianNumber($player['total_score']) : "۰"; ?>
                        </p>
                    </section>
                    <section class="top_player_rank">
                        <p><?php echo \Core\Utils::PersianNumber($rank); ?></p>
                    </section>
                </li>
            <?php
                    }
                }
            ?>
        </ul>

    </section>
<?php
}
?>