<?php
namespace Core;
class Excel{
    use ErrorsTrait;
    private $filename;

    public function __construct($filename = null){
        // Set a default filename if none is provided
        $this->filename = $filename ?: 'export.csv';
    }

    public function export($data): bool|string{
        // Create a unique filename based on the current timestamp
        $uniqueFilename = time() . '_' . $this->filename;
        //create directory if not exists
        $path = '/public/uploads/exports';
        if(!is_dir(YOOZ_ROOT.$path)){
            if(!mkdir(YOOZ_ROOT.$path , 0755, true)){
                $this->set_error("دایرکتوری فایل خروجی ایجاد نشد.");
            }
        }

        if(!$this->has_error()){
            // Set the full path to the new file
            $filePath = $path."/".$uniqueFilename;
            $fileWholePath = YOOZ_ROOT.$filePath;
            // Open the file for writing in binary mode
            $file = fopen($fileWholePath, 'w');
            if($file) {
                fwrite($file, "\xEF\xBB\xBF"); // UTF-8 BOM
                // Write each row of data to the CSV
                foreach ($data as $row) {
                    fputcsv($file, $row);
                }
                // Close the file
                fclose($file);
                return $filePath;
            }else{
                $this->set_error("فایل خروجی ایجاد نشد.");
            }
        }

        return false;
    }
}
?>