<?php
namespace Core\File_Handler;

class Resize_Image{
    /*
         $crop_covermode => if want to crop from edges and keep center set this to true and if want to keep the top and left image and crop two sides right ond bottom set this to false
     */
    private function resize_image($source_file, $width, $height, $fileType , $crop=FALSE , $crop_covermode = true , $encode_source = false){
        $response = false;
        if($fileType == "png" || $fileType == "jpg"){
            $sourceX_coordinate = $sourceY_coordinate = 0;
            $source_url = ($encode_source) ? str_replace(" " , "%20" , $source_file) : $source_file;
            $image_sizes = @getimagesize($source_url);
            if($image_sizes){
                $sourceWidth = $image_sizes[0];
                $sourceHeight = $image_sizes[1];

                $absSourceWidth = $sourceWidth;
                $absSourceHeight = $sourceHeight;
                $ratio = $sourceWidth / $sourceHeight;
                if ($crop) {
                    if ($sourceWidth > $sourceHeight) {
                        $sourceWidth = ceil($sourceWidth-($width*abs($ratio-$width/$height)));
                    } else {
                        $sourceHeight = ceil($sourceHeight-($sourceHeight*abs($ratio-$width/$height)));
                    }
                    if($crop_covermode){
                        if($sourceWidth < $absSourceWidth){
                            $sourceX_coordinate = ($absSourceWidth - $sourceWidth) / 2;
                        }
                        if($sourceHeight < $absSourceHeight){
                            $sourceY_coordinate = ($absSourceHeight - $sourceHeight) / 2;
                        }
                    }
                    $new_width = $width;
                    $new_height = $height;
                } else {
                    if ($width/$height > $ratio) {
                        $new_width = $height*$ratio;
                        $new_height = $height;
                    } else {
                        $new_height = $width/$ratio;
                        $new_width = $width;
                    }
                }

                if($fileType == "jpg"){ $source = imagecreatefromjpeg($source_url); }
                if($fileType == "png"){ $source = imagecreatefrompng($source_url); }

                $newFile = imagecreatetruecolor((int) $new_width, (int) $new_height);
                if($fileType == "png"){
                    imagesavealpha($newFile, true);
                    $color = imagecolorallocatealpha($newFile, 0, 0, 0, 127);
                    imagefill($newFile, 0, 0, $color);
                }
                imagecopyresampled($newFile, $source, 0, 0, (int) $sourceX_coordinate, (int) $sourceY_coordinate, (int) $new_width, (int) $new_height, (int) $sourceWidth, (int) $sourceHeight);
                $response = $newFile;
            }
        }
        return $response;
    }

    public function create_resized_image($resized_file_name , $source_file , $width , $height , $crop = false , $crop_covermode = true , $encode_source = false){
        $response = false;
        $fileType = strtolower(pathinfo($source_file , PATHINFO_EXTENSION));
        $fileType = ($fileType == "jpeg") ? "jpg" : $fileType;
        if($fileType == "png" || $fileType == "jpg"){
            $resized_image = $this->resize_image($source_file , $width , $height , $fileType , $crop , $crop_covermode , $encode_source);
            if($resized_image){
                if($fileType == "jpg"){ $response = imagejpeg($resized_image, $resized_file_name); }
                if($fileType == "png"){ $response = imagepng($resized_image, $resized_file_name); }
            }
        }
        return $response;
    }


}