<?php
namespace Core;
class License{
    private static $designer_name = null;
    private static $designer_logo = null;
    private static $designer_url = null;
    private static $expire_date = null;
    private static $error_message = null;
    private static $license_html = null;
    private static $api_address = "https://modir.imanirad.ir/api";
    
    public static function check_license_key($license_key){
        $api_address = self::$api_address;
        $api_address .= "?lk=".bin2hex(base64_encode($license_key));//lk means license key
        $api_address .= "&ld=".Utils::get_site_url();//ld means license domain
        $api_response = @file_get_contents($api_address);
        if(!empty($api_response)){
            $api_value = json_decode(stripslashes($api_response) , true);
            if($api_value && is_array($api_value) && !empty($api_value['status'])){
                if($api_value['status'] == "ok"){
                    return true;
                }
            }
        }
        
        return false;
    }
    
    public static function init($force_update = false){
        $api_address = self::$api_address;
        $licenseKey = Site_Options::get("_yooz_app_license_key_");
        $licenseKey = !empty($licenseKey) ? $licenseKey : "";
        $api_address .= "?lk=".bin2hex(base64_encode($licenseKey));//lk means license key
        $api_address .= "&ld=".Utils::get_site_url();//ld means license domain
        $api_value = false;

        //check if data is set on database
        $api_db_option = Site_Options::get("_yooz_designer_info_");
        $api_db_data = !empty($api_db_option) ? unserialize($api_db_option) : [];
        if(!empty($api_db_data) && is_array($api_db_data) && !empty($api_db_data['expire_date']) && is_numeric($api_db_data['expire_date'])){
            if($api_db_data['expire_date'] >= time()){
                $api_value = $api_db_data;
            }
        }

        if($api_value === false || $force_update === true){
            $api_response = file_get_contents($api_address);
            if(!empty($api_response)){
                $api_value = json_decode(stripslashes($api_response) , true);
            }
        }

        if($api_value && is_array($api_value) && !empty($api_value['status'])){
            if($api_value['status'] == "ok"){
                if(!empty($api_value['expire_date']) && is_numeric($api_value['expire_date'])){

                    $currentTime = time();
                    $expireTime = $api_value['expire_date'];
                    $currentDate = new \DateTime();
                    $expiredDate = new \DateTime(date("Y-m-d H:i:s" , $expireTime));
                    $interval = $currentDate->diff($expiredDate);
                    
                    $expireDistance = -1;
                    if($interval->invert > 0){//if the different is negative the invert equal to 1
                        $expireDistance = $interval->days * -1;
                    }else{
                        $expireDistance = $interval->days;
                        $monthsDifference = ($interval->y * 12) + $interval->m;
//                        if($monthsDifference > 0){
//                            $expire_value = Utils::PersianNumber($monthsDifference) ." ماه";
//                            if($interval->d > 0){
//                                $expire_value .= " و ".$interval->d." روز";
//                            }
//                        }elseif($monthsDifference == 0 && $interval->d > 0){
//                            $expire_value = $interval->d." روز";
//                        }
                        $expire_value = $expireDistance." روز";
                    }
 
                    /* update data in db */
                    self::$designer_name= !empty($api_value['designer_brand_name']) ? $api_value['designer_brand_name'] : "";
                    self::$designer_logo= !empty($api_value['designer_logo']) ? $api_value['designer_logo'] : "";
                    self::$designer_url = !empty($api_value['designer_url']) ? $api_value['designer_url'] : "";
                    self::$expire_date  = !empty($expire_value) ? $expire_value : 0;
                    Site_Options::update("_yooz_designer_info_" , serialize($api_value));

                    $controller = Router::get_controller();
                    if($expireDistance < 0){//end deadline
                        if($controller !== "api"){
                            require_once __DIR__."/License_Alerts/End_Deadline.php";
                            exit();
                        }
                    }elseif($expireDistance < 31){//one month deadline
                        if($controller !== "ajax" && $controller !== "api"){
                            $app_type = Router::get_app_type();
                            if($app_type === "Admin" && $controller !== "login"){
                                require_once __DIR__."/License_Alerts/Has_Deadline.php";
                                self::$license_html = get_license_alert_html($expireDistance);
                            }

                        }
                    }

                }else{
                    self::$error_message = "خطا در داده های لایسنس.";
                }
            }else{
                if(!empty($api_value['message']) && str_contains($api_value['message'], '3')) {
                    Site_Options::update("_yooz_designer_info_" , serialize($api_value));
                    $controller = Router::get_controller();
                    if($controller !== "api"){
                        require_once __DIR__."/License_Alerts/Delete_License.php";
                        exit();
                    }
                }
                if(!empty($api_value['message']) && str_contains($api_value['message'], '6')) {
                    Site_Options::update("_yooz_designer_info_" , serialize($api_value));
                    $controller = Router::get_controller();
                    if($controller !== "api"){
                        require_once __DIR__."/License_Alerts/Disabled_License.php";
                        exit();
                    }
                }
                self::$error_message = !empty($api_value['message']) ? $api_value['message'] : "اطلاعات API ایراد دارد.";;
            }
        }else{
            self::$error_message = 'خطای ارتباط با سامانه';
        }
    }

    public static function name(){
        return !empty(self::$designer_name) ? self::$designer_name : "سکه";
    }
    public static function logo(){
        return !empty(self::$designer_logo) ? self::$designer_logo : "https://yoozsite.ir/logo.svg";
    }
    public static function url(){
        return !empty(self::$designer_url) ? self::$designer_url : "https://seke.com";
    }
    public static function expire(){
        return !empty(self::$expire_date) ? self::$expire_date : 0;
    }
    public static function alert_html(){
        return self::$license_html;
    }

    public static function get_license_key(){
        $license = Site_Options::get("_yooz_app_license_key_");
        return !empty($license) ? $license : "";
    }
    public static function has_access(){
        if(!empty(self::$error_message)){
            die(self::$error_message);
        }
        return true;
    }
    public static function check_license(){
        self::init(true);
        return self::$error_message ?? true;
    }

}

if(!defined("DONT_INIT_LICENCE")){
    License::init();
}
 

