<?php
namespace Core;

class View{
    public function render(string $view , array $data = [] , bool $display_header = true , string $layout_file_name = ""){
        $app_type = Router::get_app_type();
        if(count($data) > 0){extract($data);}
        $view = str_replace(".php" , "" , $view);
        $file = __DIR__."/../app/Views/".$app_type."/".$view.".php";
        $file_name = !empty($layout_file_name) ? "layouts/".$layout_file_name."_layout" : $view;
        $fileDir = __DIR__."/../app/Views/".$app_type."/".$file_name.".php";
        $baseNamespace = "App\\Controllers\\".$app_type."\\";

        if(file_exists($fileDir)){
            require_once __DIR__."/../app/Views/".$app_type."/page_start.php";

            if($display_header){
                require_once __DIR__."/../app/Views/".$app_type."/header.php";
                $sidebarNamespace = $baseNamespace."Sidebar_Controller";
                if(class_exists($sidebarNamespace)){
                    $sidebarClass = new $sidebarNamespace();
                    $sidebarClass->index();
                }
            }

            echo '<div id="content_body">';
            require_once $fileDir;
            echo '</div>';

            if($display_header){
                require_once __DIR__."/../app/Views/".$app_type."/footer.php";
            }
            require_once __DIR__."/../app/Views/".$app_type."/page_end.php";
        }else{
            echo "not found related files";
        }
    }
}