<?php
namespace Core;
class Autoloader{
    public static function register(){
        spl_autoload_register([self::class , 'autoload']);
    }

    public static function autoload($class){
        $class = str_replace("\\" , "/", $class);
        $class = str_replace("App/" , "app/", $class);
        $class = str_replace("Core/" , "core/", $class);

        $file = __DIR__."/../".$class.".php";
        if(file_exists($file)){
            require_once $file;
        }
    }
}
Autoloader::register();