<?php
require_once __DIR__."/../core/autoloader.php";
/* some files use this constant to check direct access and also for absolute path of app root */
define("YOOZ_ROOT" , __DIR__."/..");

/* SITE_URL adn REQUEST_URL Cnstant will use in some files */
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443) ? "https://" : "http://";
define("SITE_URL" , $protocol.$_SERVER['SERVER_NAME']);
define("HOME_URL" , SITE_URL);
define("LOGIN_PAGE" , SITE_URL."/login");
define("REQUEST_URL" , SITE_URL.$_SERVER['REQUEST_URI']);

define("ADMIN_URL" , SITE_URL."/admin");


/* uri_array() function was set in functions.php */
use Core\Utils;
$URI_PARAMS = Utils::uri_array();
$config_file_path = __DIR__."/../config/config.php";
if(file_exists($config_file_path)){
    /* define path of config file */
    define("CONF_PATH" , __DIR__."/../config/config.php");

    $siteLogoID = \Core\Site_Options::get("site_logo");
    $logo = $favicon = SITE_URL."/public/uploads/dafault_store_logo.png";
    if($siteLogoID && is_numeric($siteLogoID)){
        $file = \Plugins\Yooz_Manager\Yooz_Manager_Utils::get_file_by_id($siteLogoID);
        if($file && is_array($file) && !empty($file['file_url'])){
            $logo = $file['file_url'];
            if(!empty($file['file_data'])){
                $fileData = @unserialize($file['file_data']);
                if($fileData && is_array($fileData)){
                    if(!empty($fileData['large_thumbnail'])){
                        $logo = $fileData['large_thumbnail'];
                        $favicon = $fileData['large_thumbnail'];
                    }
                    if(!empty($fileData['small_thumbnail'])){
                        $favicon = $fileData['small_thumbnail'];
                    }
                }
            }
        }

    }
    define("FAV_ICON" , $favicon);
    define("SITE_LOGO" , $logo);
    $siteName = \Core\Site_Options::get("site_name");
    define("SITE_NAME" , !empty($siteName) ? $siteName : "سکه");
    $siteDescriptions = \Core\Site_Options::get("site_descriptions");
    define("SITE_DESCRIPTIONS" , !empty($siteDescriptions) ? $siteDescriptions : "");
    
    /* create connection to database */
    $yooz_db = new Core\YoozDB();
    if(!$yooz_db->check_connection()){
        die("خطای ارتباط با سرور. لطفا دوباره تلاش کنید.");
        exit();
    }

    if(!empty($URI_PARAMS[0]) && ($URI_PARAMS[0] === "style" || $URI_PARAMS[0] === "js")){
        $fileType = $URI_PARAMS[0];
        require_once YOOZ_ROOT."/public/assets/compactScripts.php";
    }else{
        $router = require_once __DIR__."/routes.php";
        $router->dispatch();
    }
}else{
    $installer = new Core\Installer($config_file_path);
}